/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.ABI;
import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.JavaDistribution;
import com.fizzed.jne.JavaHomes;
import com.fizzed.jne.JavaImageType;
import com.fizzed.jne.JavaVersion;
import com.fizzed.jne.OperatingSystem;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHome {
    private static final Logger log = LoggerFactory.getLogger(JavaHome.class);
    private final Path directory;
    private final Path javaExe;
    private final Path javacExe;
    private final Path nativeImageExe;
    private final OperatingSystem operatingSystem;
    private final HardwareArchitecture hardwareArchitecture;
    private final ABI abi;
    private final String vendor;
    private final JavaDistribution distribution;
    private final JavaVersion version;
    private final Map<String, String> releaseProperties;

    JavaHome(Path directory, Path javaExe, Path javacExe, Path nativeImageExe, OperatingSystem operatingSystem, HardwareArchitecture hardwareArchitecture, ABI abi, String vendor, JavaDistribution distro, JavaVersion version, Map<String, String> releaseProperties) {
        this.directory = directory;
        this.javaExe = javaExe;
        this.javacExe = javacExe;
        this.nativeImageExe = nativeImageExe;
        this.operatingSystem = operatingSystem;
        this.hardwareArchitecture = hardwareArchitecture;
        this.abi = abi;
        this.vendor = vendor;
        this.distribution = distro;
        this.version = version;
        this.releaseProperties = releaseProperties;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Path getJavaExe() {
        return this.javaExe;
    }

    public Path getJavacExe() {
        return this.javacExe;
    }

    public Path getNativeImageExe() {
        return this.nativeImageExe;
    }

    public JavaImageType getImageType() {
        if (this.nativeImageExe != null) {
            return JavaImageType.NIK;
        }
        if (this.javacExe != null) {
            return JavaImageType.JDK;
        }
        return JavaImageType.JRE;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public HardwareArchitecture getHardwareArchitecture() {
        return this.hardwareArchitecture;
    }

    public ABI getAbi() {
        return this.abi;
    }

    public String getVendor() {
        return this.vendor;
    }

    public JavaDistribution getDistribution() {
        return this.distribution;
    }

    public JavaVersion getVersion() {
        return this.version;
    }

    public Map<String, String> getReleaseProperties() {
        return this.releaseProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.distribution != null) {
            sb.append(this.distribution.getDescriptor());
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append((Object)this.getImageType());
        sb.append(" ").append(this.version);
        sb.append(" (");
        if (this.operatingSystem != null) {
            sb.append(this.operatingSystem.getDescriptor());
            if (this.hardwareArchitecture != null) {
                sb.append(", ");
                sb.append(this.hardwareArchitecture.getDescriptor());
            }
            sb.append(", ");
        }
        sb.append(this.directory);
        sb.append(")");
        return sb.toString();
    }

    public static JavaHome current() throws IOException {
        Path javaHomeDir = Paths.get(System.getProperty("java.home"), new String[0]);
        return JavaHome.current(javaHomeDir);
    }

    static JavaHome current(Path javaHomeDir) throws IOException {
        return JavaHomes.detect(javaHomeDir, false, JavaHomes.CURRENT_JVM_RELEASE_PROPERTIES_PROVIDER);
    }
}

