/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.ABI;
import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.JavaDistribution;
import com.fizzed.jne.JavaHome;
import com.fizzed.jne.JavaVersion;
import com.fizzed.jne.NativeTarget;
import com.fizzed.jne.OperatingSystem;
import com.fizzed.jne.PlatformInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHomes {
    private static final Logger log = LoggerFactory.getLogger(JavaHome.class);
    public static final ReleasePropertiesProvider EXECUTE_JAVA_VERSION_RELEASE_PROPERTIES_PROVIDER = new ReleasePropertiesProvider(){

        @Override
        public boolean asFallbackOnly() {
            return true;
        }

        @Override
        public Map<String, String> apply(Path javaHomeDir, Path javaExeFile) throws IOException {
            try {
                String versionOutput = JavaHomes.executeJavaVersion(javaExeFile);
                return JavaHomes.readJavaVersionOutput(versionOutput);
            }
            catch (Exception e) {
                throw new IOException("Unable to execute -version command on " + javaExeFile, e);
            }
        }
    };
    public static final ReleasePropertiesProvider CURRENT_JVM_RELEASE_PROPERTIES_PROVIDER = new ReleasePropertiesProvider(){

        @Override
        public boolean asFallbackOnly() {
            return false;
        }

        @Override
        public Map<String, String> apply(Path javaHomeDir, Path javaExeFile) throws IOException {
            String osArch;
            String osName;
            String javaVendorVersion;
            String javaVendor;
            HashMap<String, String> releaseProperties = new HashMap<String, String>();
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null) {
                releaseProperties.put("JAVA_VERSION", javaVersion);
            }
            if ((javaVendor = System.getProperty("java.vendor")) != null) {
                releaseProperties.put("IMPLEMENTOR", javaVendor);
            }
            if ((javaVendorVersion = System.getProperty("java.vendor.version")) != null) {
                releaseProperties.put("IMPLEMENTOR_VERSION", javaVendorVersion);
            }
            if ((osName = System.getProperty("os.name")) != null) {
                releaseProperties.put("OS_NAME", osName);
            }
            if ((osArch = System.getProperty("os.arch")) != null) {
                releaseProperties.put("OS_ARCH", osArch);
            }
            return releaseProperties;
        }
    };

    public static JavaHome detect(Path javaHomeDir) throws IOException {
        return JavaHomes.detect(javaHomeDir, false);
    }

    public static JavaHome detect(Path javaHomeDir, boolean requireReleaseFile) throws IOException {
        return JavaHomes.detect(javaHomeDir, requireReleaseFile, EXECUTE_JAVA_VERSION_RELEASE_PROPERTIES_PROVIDER);
    }

    public static JavaHome detect(Path javaHomeDir, boolean requireReleaseFile, ReleasePropertiesProvider releasePropertiesFallbackProvider) throws IOException {
        String releaseLibc;
        String releaseArch;
        String releaseOs;
        String releaseJavaVersion;
        Map<String, String> extraReleaseProperties;
        Path rtJarFile;
        Path jreDir;
        Path releaseFile;
        Path javaLibDir;
        Path jdkHomeDir;
        Path javaExeFileAlt;
        if (!Files.isDirectory(javaHomeDir, new LinkOption[0])) {
            throw new FileNotFoundException("Java home directory " + javaHomeDir + " does not exist");
        }
        OperatingSystem thisOs = PlatformInfo.detectOperatingSystem();
        String javaExeFileName = NativeTarget.resolveExecutableFileName(thisOs, "java");
        Path javaExeFile = javaHomeDir.resolve("bin").resolve(javaExeFileName);
        if (!Files.isRegularFile(javaExeFile, new LinkOption[0])) {
            throw new FileNotFoundException("Java executable " + javaExeFile + " was not found in " + javaHomeDir);
        }
        if ("jre".equalsIgnoreCase(javaHomeDir.getFileName().toString()) && Files.isRegularFile(javaExeFileAlt = (jdkHomeDir = javaHomeDir.getParent()).resolve("bin").resolve(javaExeFileName), new LinkOption[0])) {
            javaHomeDir = jdkHomeDir;
            javaExeFile = javaExeFileAlt;
        }
        if (!Files.isDirectory(javaLibDir = javaHomeDir.resolve("lib"), new LinkOption[0])) {
            throw new FileNotFoundException("Java lib directory " + javaLibDir + " was not found in " + javaHomeDir);
        }
        Path jmodsDir = javaHomeDir.resolve("jmods");
        if (!(Files.isDirectory(jmodsDir, new LinkOption[0]) || Files.exists(releaseFile = javaHomeDir.resolve("release"), new LinkOption[0]) || Files.isDirectory(jreDir = javaHomeDir.resolve("jre"), new LinkOption[0]) || Files.exists(rtJarFile = javaLibDir.resolve("rt.jar"), new LinkOption[0]))) {
            throw new FileNotFoundException("Java jmods/jre directory, or release file not found in " + javaHomeDir);
        }
        String javacExeFileName = NativeTarget.resolveExecutableFileName(thisOs, "javac");
        Path javacExeFile = javaHomeDir.resolve("bin").resolve(javacExeFileName);
        if (!Files.isRegularFile(javacExeFile, new LinkOption[0])) {
            javacExeFile = null;
        }
        String nativeImageExeFileName = NativeTarget.resolveExecutableFileName(thisOs, "native-image");
        Path nativeImageExeFile = javaHomeDir.resolve("bin").resolve(nativeImageExeFileName);
        if (!Files.isRegularFile(nativeImageExeFile, new LinkOption[0])) {
            nativeImageExeFile = null;
        }
        JavaVersion version = null;
        String vendor = null;
        String implementorVersion = null;
        OperatingSystem operatingSystem = null;
        HardwareArchitecture hardwareArchitecture = null;
        ABI abi = null;
        Map<String, String> releaseProperties = null;
        Path releaseFile2 = javaHomeDir.resolve("release");
        if (Files.isRegularFile(releaseFile2, new LinkOption[0])) {
            releaseProperties = JavaHomes.readReleaseProperties(releaseFile2);
        }
        if (releaseProperties == null) {
            if (requireReleaseFile) {
                throw new FileNotFoundException("Java release file " + releaseFile2 + " was not found in " + javaHomeDir);
            }
            if (releasePropertiesFallbackProvider != null) {
                releaseProperties = releasePropertiesFallbackProvider.apply(javaHomeDir, javaExeFile);
            }
        } else if (releasePropertiesFallbackProvider != null && !releasePropertiesFallbackProvider.asFallbackOnly() && (extraReleaseProperties = releasePropertiesFallbackProvider.apply(javaHomeDir, javaExeFile)) != null) {
            Map<String, String> finalReleaseProperties = releaseProperties;
            extraReleaseProperties.forEach((k, v) -> {
                if (!finalReleaseProperties.containsKey(k)) {
                    finalReleaseProperties.put((String)k, (String)v);
                }
            });
        }
        if (!(releasePropertiesFallbackProvider == null || releaseProperties != null && releasePropertiesFallbackProvider.asFallbackOnly())) {
            releaseProperties = releasePropertiesFallbackProvider.apply(javaHomeDir, javaExeFile);
        }
        if ((releaseJavaVersion = releaseProperties.get("JAVA_VERSION")) != null) {
            version = JavaVersion.parse(releaseJavaVersion);
        }
        if ((releaseOs = releaseProperties.get("OS_NAME")) != null) {
            operatingSystem = OperatingSystem.resolve(releaseOs);
        }
        if ((releaseArch = releaseProperties.get("OS_ARCH")) != null && (hardwareArchitecture = HardwareArchitecture.resolve(releaseArch)) == null && "arm".equalsIgnoreCase(releaseArch)) {
            String sunArchAbi = releaseProperties.get("SUN_ARCH_ABI");
            if ("gnueabihf".equalsIgnoreCase(sunArchAbi)) {
                hardwareArchitecture = HardwareArchitecture.ARMHF;
            } else if ("gnueabi".equalsIgnoreCase(sunArchAbi)) {
                hardwareArchitecture = HardwareArchitecture.ARMEL;
            }
        }
        if ((releaseLibc = releaseProperties.get("LIBC")) != null) {
            abi = ABI.resolve(releaseLibc);
        }
        vendor = releaseProperties.get("IMPLEMENTOR");
        implementorVersion = releaseProperties.get("IMPLEMENTOR_VERSION");
        JavaDistribution distro = JavaDistribution.resolve(vendor);
        if (distro == null && (distro = JavaDistribution.resolve(implementorVersion)) == null) {
            distro = JavaDistribution.resolve(javaHomeDir.toString());
        }
        return new JavaHome(javaHomeDir, javaExeFile, javacExeFile, nativeImageExeFile, operatingSystem, hardwareArchitecture, abi, vendor, distro, version, releaseProperties);
    }

    public static Map<String, String> readReleaseProperties(Path releaseFile) throws IOException {
        List<String> lines = Files.readAllLines(releaseFile);
        HashMap<String, String> nameValues = new HashMap<String, String>();
        for (String line : lines) {
            int equalsPos = line.indexOf(61);
            if (equalsPos <= 2 || equalsPos >= line.length() - 2) continue;
            String name = line.substring(0, equalsPos);
            String value = line.charAt(equalsPos + 1) == '\"' && line.charAt(line.length() - 1) == '\"' ? line.substring(equalsPos + 2, line.length() - 1) : line.substring(equalsPos + 1);
            nameValues.put(name, value);
        }
        return nameValues;
    }

    public static String executeJavaVersion(Path javaExeFile) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(new String[0]).command(javaExeFile.toString(), "-version").redirectErrorStream(true).start();
        process.getOutputStream().close();
        StringBuilder output = new StringBuilder();
        byte[] buf = new byte[1024];
        try (InputStream input = process.getInputStream();){
            int read = 1;
            while (read > 0) {
                read = input.read(buf);
                if (read <= 0) continue;
                output.append(new String(buf, 0, read, StandardCharsets.UTF_8));
            }
        }
        process.waitFor(5L, TimeUnit.SECONDS);
        if (process.exitValue() != 0) {
            throw new IOException("Version command failed with exit value " + process.exitValue());
        }
        return output.toString();
    }

    public static Map<String, String> readJavaVersionOutput(String versionOutput) throws IOException {
        int implEndPos;
        String line2;
        int implStartPos;
        int doubleQuoteEndPos;
        String[] lines = versionOutput.split("\n");
        HashMap<String, String> nameValues = new HashMap<String, String>();
        String line1 = lines[0];
        int doubleQuoteStartPos = line1.indexOf(34);
        if (doubleQuoteStartPos > 0 && (doubleQuoteEndPos = line1.indexOf(34, doubleQuoteStartPos + 1)) > doubleQuoteStartPos) {
            String version = line1.substring(doubleQuoteStartPos + 1, doubleQuoteEndPos);
            nameValues.put("JAVA_VERSION", version.trim());
        }
        if (lines.length > 1 && (implStartPos = (line2 = lines[1]).toLowerCase().indexOf("runtime environment ")) > 0 && (implEndPos = line2.indexOf(" (build", implStartPos + 1)) > implStartPos + 23) {
            String implementerVersion = line2.substring(implStartPos + 20, implEndPos);
            if (implementerVersion.charAt(0) == '(' && implementerVersion.charAt(implementerVersion.length() - 1) == ')') {
                implementerVersion = implementerVersion.substring(1, implementerVersion.length() - 1);
            }
            nameValues.put("IMPLEMENTOR_VERSION", implementerVersion.trim());
        }
        return nameValues;
    }

    public static List<JavaHome> detect() throws Exception {
        NativeTarget nativeTarget = NativeTarget.detect();
        log.trace("Detected operating system {}", (Object)nativeTarget.getOperatingSystem());
        LinkedHashSet<Path> maybeJavaHomes = new LinkedHashSet<Path>();
        JavaHomes.locateJavaHomeFromThisJvm(maybeJavaHomes);
        JavaHomes.locateJavaHomeFromJavaHomeEnvVar(maybeJavaHomes);
        JavaHomes.locateJavaHomesFromPathEnvVar(maybeJavaHomes, nativeTarget);
        switch (nativeTarget.getOperatingSystem()) {
            case LINUX: {
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("/usr/lib/jvm", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("/usr/java", new String[0]), ".*");
                break;
            }
            case MACOS: {
                Path contentsHomeDir = Paths.get("Contents/Home", new String[0]);
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("/Library/Java/JavaVirtualMachines", new String[0]), ".*", contentsHomeDir);
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("/System/Library/Java/JavaVirtualMachines", new String[0]), ".*", contentsHomeDir);
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("/Library/Internet Plug-Ins", new String[0]), "Java.*", contentsHomeDir);
                break;
            }
            case WINDOWS: {
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\Zulu", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\Zulu", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\Eclipse Adoptium", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\Eclipse Adoptium", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\BellSoft", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\BellSoft", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\Amazon Corretto", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\Amazon Corretto", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\Microsoft", new String[0]), "jdk.*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\Microsoft", new String[0]), "jdk.*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\SapMachine\\JDK", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\SapMachine\\JDK", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files\\Semeru", new String[0]), ".*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, Paths.get("C:\\Program Files (x86)\\Semeru", new String[0]), ".*");
                break;
            }
            case FREEBSD: 
            case OPENBSD: {
                Path usrLocalPath = Paths.get("/usr/local", new String[0]);
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, usrLocalPath, "openjdk.*");
                JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, usrLocalPath, "jdk.*");
            }
        }
        ArrayList<JavaHome> javaHomes = new ArrayList<JavaHome>();
        for (Path maybeJavaHome : maybeJavaHomes) {
            log.trace("detectJavaHome: {}", (Object)maybeJavaHome);
            JavaHome javaHome = null;
            try {
                javaHome = JavaHomes.detect(maybeJavaHome);
                javaHomes.add(javaHome);
            }
            catch (Exception e) {
                log.trace("  was NOT a java home: {}", (Object)e.getMessage());
            }
        }
        return javaHomes;
    }

    private static void locateJavaHomeFromThisJvm(Set<Path> maybeJavaHomes) throws IOException {
        String javaHomeSysProp = System.getProperty("java.home");
        if (javaHomeSysProp != null) {
            Path p = Paths.get(javaHomeSysProp, new String[0]);
            log.trace("locateJavaHomeFromThisJvm: {}", (Object)javaHomeSysProp);
            if (!maybeJavaHomes.contains(p)) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (!maybeJavaHomes.contains(p = p.toRealPath(new LinkOption[0]))) {
                        log.trace("  adding possible java home {}", (Object)p);
                        maybeJavaHomes.add(p);
                    } else {
                        log.trace("  skipping, already present java home {}", (Object)p);
                    }
                }
            } else {
                log.trace("  skipping, already present java home {}", (Object)p);
            }
        }
    }

    private static void locateJavaHomeFromJavaHomeEnvVar(Set<Path> maybeJavaHomes) throws IOException {
        String javaHomeEnvVar = System.getenv("JAVA_HOME");
        if (javaHomeEnvVar != null && !javaHomeEnvVar.isEmpty()) {
            Path p = Paths.get(javaHomeEnvVar, new String[0]);
            log.trace("locateJavaHomeFromJavaHomeEnvVar: {}", (Object)javaHomeEnvVar);
            if (!maybeJavaHomes.contains(p)) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (!maybeJavaHomes.contains(p = p.toRealPath(new LinkOption[0]))) {
                        log.trace("  adding possible java home {}", (Object)p);
                        maybeJavaHomes.add(p);
                    } else {
                        log.trace("  skipping, already present java home {}", (Object)p);
                    }
                }
            } else {
                log.trace("  skipping, already present java home {}", (Object)p);
            }
        }
    }

    private static void locateJavaHomesFromPathEnvVar(Set<Path> maybeJavaHomes, NativeTarget nativeTarget) throws IOException {
        String javaExeFileName = nativeTarget.resolveExecutableFileName("java");
        String pathEnvVar = System.getenv("PATH");
        if (pathEnvVar != null && !pathEnvVar.isEmpty()) {
            String[] paths;
            for (String path : paths = pathEnvVar.split(File.pathSeparator)) {
                log.trace("locateJavaHomesFromPathEnvVar: {}", (Object)path);
                Path javaExeFile = Paths.get(path, new String[0]).resolve(javaExeFileName);
                if (Files.exists(javaExeFile, new LinkOption[0])) {
                    Path p = javaExeFile.toRealPath(new LinkOption[0]).resolve("../..").normalize();
                    if (!maybeJavaHomes.contains(p)) {
                        maybeJavaHomes.add(p);
                        log.trace("  adding possible java home {}", (Object)p);
                        continue;
                    }
                    log.trace("  skipping, already present java home {}", (Object)p);
                    continue;
                }
                log.trace("  skipping, no {} present", (Object)javaExeFileName);
            }
        }
    }

    private static void locateJavaHomesFromDir(Set<Path> maybeJavaHomes, Path searchDir, String nameRegex) throws IOException {
        JavaHomes.locateJavaHomesFromDir(maybeJavaHomes, searchDir, nameRegex, null);
    }

    private static void locateJavaHomesFromDir(Set<Path> maybeJavaHomes, Path searchDir, String nameRegex, Path subDir) throws IOException {
        log.trace("locateJavaHomesFromDir: {} with regex {}", (Object)searchDir, (Object)nameRegex);
        if (!Files.isDirectory(searchDir, new LinkOption[0])) {
            log.trace("  skipping, dir does not exist (or is a file)");
            return;
        }
        Pattern namePattern = Pattern.compile(nameRegex);
        try (Stream<Path> paths = Files.list(searchDir);){
            paths.forEach(p -> {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    String name = p.getFileName().toString();
                    if (namePattern.matcher(name).matches()) {
                        try {
                            p = p.toRealPath(new LinkOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        if (subDir != null && !Files.isDirectory(p = p.resolve(subDir), new LinkOption[0])) {
                            return;
                        }
                        if (!maybeJavaHomes.contains(p)) {
                            log.trace("  adding possible java home {}", p);
                            maybeJavaHomes.add((Path)p);
                        } else {
                            log.trace("  skipping, already present java home {}", p);
                        }
                    } else {
                        log.trace("  skipping, name {} does not match regex", (Object)name);
                    }
                }
            });
        }
    }

    public static interface ReleasePropertiesProvider {
        public boolean asFallbackOnly();

        public Map<String, String> apply(Path var1, Path var2) throws IOException;
    }
}

