/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacDscl {
    private static final Logger log = LoggerFactory.getLogger(MacDscl.class);
    private Path homeDir;
    private Path shell;
    private String realName;
    private Integer uniqueId;
    private Integer primaryGroupId;

    public Path getHomeDir() {
        return this.homeDir;
    }

    public Path getShell() {
        return this.shell;
    }

    public String getRealName() {
        return this.realName;
    }

    public Integer getUniqueId() {
        return this.uniqueId;
    }

    public Integer getPrimaryGroupId() {
        return this.primaryGroupId;
    }

    public static MacDscl readByUser(String user) throws Exception {
        Path usersDir = Paths.get("/Users", new String[0]);
        if (!Files.exists(usersDir, new LinkOption[0])) {
            log.warn("{} was expected to exist, but is missing, unable to lookup user {}", (Object)usersDir, (Object)user);
            return null;
        }
        Path homeDir = usersDir.resolve(user);
        if (!Files.exists(homeDir, new LinkOption[0])) {
            log.warn("Home directory {} was not found for user {}", (Object)homeDir, (Object)user);
            return null;
        }
        return MacDscl.readByHomeDirectory(homeDir);
    }

    public static MacDscl readByHomeDirectory(Path homeDir) throws Exception {
        List<String> commands = Arrays.asList("dscl", ".", "-read", homeDir.toAbsolutePath().toString());
        String output = Utils.execAndGetOutput(commands);
        return MacDscl.readOutput(output);
    }

    public static MacDscl readOutput(String output) {
        MacDscl v = new MacDscl();
        int pos = 0;
        int nextNewlinePos = output.indexOf(10, pos);
        while (nextNewlinePos > 0) {
            int _nextNewLinePos;
            String line = output.substring(pos, nextNewlinePos);
            if (line.startsWith("UserShell:")) {
                v.shell = Paths.get(line.substring(10).trim(), new String[0]);
            } else if (line.startsWith("NFSHomeDirectory:")) {
                v.homeDir = Paths.get(line.substring(17).trim(), new String[0]);
            } else if (line.startsWith("UniqueID:")) {
                v.uniqueId = Integer.valueOf(line.substring(9).trim());
            } else if (line.startsWith("PrimaryGroupID:")) {
                v.primaryGroupId = Integer.valueOf(line.substring(15).trim());
            } else if (line.startsWith("RealName:") && (_nextNewLinePos = output.indexOf(10, nextNewlinePos + 1)) > 0) {
                v.realName = output.substring(nextNewlinePos + 1, _nextNewLinePos).trim();
            }
            pos = nextNewlinePos + 1;
            nextNewlinePos = output.indexOf(10, pos);
        }
        return v;
    }
}

