/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.EnvPath;
import com.fizzed.jne.EnvVar;
import com.fizzed.jne.ShellType;
import java.util.Arrays;
import java.util.List;

public class ShellBuilder {
    private final ShellType shellType;

    public ShellBuilder(ShellType shellType) {
        this.shellType = shellType;
    }

    public List<String> sectionBegin(String unitName) {
        return Arrays.asList(this.comment("begin " + unitName + " environment"), this.comment("do not edit any text from begin to end comments"), "");
    }

    public List<String> sectionEnd(String unitName) {
        return Arrays.asList("", this.comment("end " + unitName + " environment"));
    }

    public String comment(String message) {
        return "# " + message;
    }

    public String exportEnvVar(EnvVar var) {
        switch (this.shellType) {
            case SH: 
            case BASH: 
            case ZSH: 
            case KSH: {
                return "export " + var.getName() + "=\"" + var.getValue() + "\"";
            }
            case TCSH: 
            case CSH: {
                return "setenv " + var.getName() + " \"" + var.getValue() + "\"";
            }
        }
        throw new IllegalArgumentException("Unsupported shell type: " + (Object)((Object)this.shellType));
    }

    public String addEnvPath(EnvPath path) {
        switch (this.shellType) {
            case SH: 
            case BASH: 
            case KSH: {
                if (path.isPrepend()) {
                    return "case \":$PATH:\" in *:\"" + path.getValue() + "\":*) ;; *) PATH=\"" + path.getValue() + "${PATH:+:$PATH}\" ;; esac; export PATH";
                }
                return "case \":$PATH:\" in *:\"" + path.getValue() + "\":*) ;; *) PATH=\"${PATH:+$PATH:}" + path.getValue() + "\" ;; esac; export PATH";
            }
            case ZSH: {
                if (path.isPrepend()) {
                    return "[[ ! \"$PATH\" =~ (^|:)" + path.getValue() + "(:|$) ]] && export PATH=\"" + path.getValue() + ":$PATH\"";
                }
                return "[[ ! \"$PATH\" =~ (^|:)" + path.getValue() + "(:|$) ]] && export PATH=\"$PATH:" + path.getValue() + "\"";
            }
            case TCSH: 
            case CSH: {
                if (path.isPrepend()) {
                    return "if (\"$PATH\" !~ *" + path.getValue() + "*) setenv PATH \"" + path.getValue() + ":${PATH}\"";
                }
                return "if (\"$PATH\" !~ *" + path.getValue() + "*) setenv PATH \"${PATH}:" + path.getValue() + "\"";
            }
        }
        throw new IllegalArgumentException("Unsupported shell type: " + (Object)((Object)this.shellType));
    }
}

