/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.compiler.GeneratorException;
import com.fizzed.rocker.compiler.JavaGenerator;
import com.fizzed.rocker.compiler.RockerConfiguration;
import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.TemplateParser;
import com.fizzed.rocker.model.TemplateModel;
import com.fizzed.rocker.runtime.ParserException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGeneratorMain {
    private static final Logger log = LoggerFactory.getLogger(JavaGeneratorMain.class);
    private final RockerConfiguration configuration = new RockerConfiguration();
    private final TemplateParser parser = new TemplateParser(this.configuration);
    private final JavaGenerator generator = new JavaGenerator(this.configuration);
    private final List<File> templateFiles = new ArrayList<File>();
    private String suffixRegex = ".*\\.rocker\\.(raw|html)$";
    private boolean failOnError = true;

    public String getSuffixRegex() {
        return this.suffixRegex;
    }

    public void setSuffixRegex(String suffixRegex) {
        this.suffixRegex = suffixRegex;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public TemplateParser getParser() {
        return this.parser;
    }

    public JavaGenerator getGenerator() {
        return this.generator;
    }

    public void run() throws Exception {
        if (this.configuration.getTemplateDirectory() == null) {
            throw new Exception("Template directory was null");
        }
        if (!this.configuration.getTemplateDirectory().exists() || !this.configuration.getTemplateDirectory().isDirectory()) {
            throw new Exception("Template directory does not exist: " + this.configuration.getTemplateDirectory());
        }
        Collection<File> allFiles = RockerUtil.listFileTree(this.configuration.getTemplateDirectory());
        for (File f : allFiles) {
            if (!f.getName().matches(this.suffixRegex)) continue;
            this.templateFiles.add(f);
        }
        log.info("Parsing " + this.templateFiles.size() + " rocker template files");
        int errors = 0;
        int generated = 0;
        for (File f : this.templateFiles) {
            TemplateModel model = null;
            try {
                model = this.parser.parse(f);
            }
            catch (ParserException | IOException e) {
                if (e instanceof ParserException) {
                    ParserException pe = (ParserException)e;
                    log.error("Parsing failed for " + f + ":[" + pe.getLineNumber() + "," + pe.getColumnNumber() + "] " + pe.getMessage());
                } else {
                    log.error("Unable to parse template", e);
                }
                ++errors;
            }
            try {
                File outputFile = this.generator.generate(model);
                ++generated;
                log.debug("Generated java source: " + outputFile);
            }
            catch (GeneratorException | IOException e) {
                throw new Exception("Generating java source failed for " + f + ": " + e.getMessage(), e);
            }
        }
        log.info("Generated " + generated + " rocker java source files");
        if (errors > 0 && this.failOnError) {
            throw new Exception("Caught " + errors + " errors.");
        }
        if (!this.configuration.getOptions().getOptimize().booleanValue()) {
            this.configuration.getClassDirectory().mkdirs();
            File configFile = new File(this.configuration.getClassDirectory(), "/rocker-compiler.conf".substring(1));
            this.configuration.write(configFile);
            log.info("Generated rocker configuration " + configFile);
        } else {
            log.info("Optimize flag on. Did not generate rocker configuration file");
        }
    }

    public static void main(String[] a) throws Exception {
        JavaGeneratorMain jgm = new JavaGeneratorMain();
        ArrayDeque<String> args = new ArrayDeque<String>(a.length);
        args.addAll(Arrays.asList(a));
        while (args.size() > 0) {
            String n = (String)args.poll();
            if (args.isEmpty()) {
                System.err.println("Not enough arguments");
                System.exit(1);
            }
            String v = (String)args.poll();
            switch (n) {
                case "-t": {
                    jgm.parser.getConfiguration().setTemplateDirectory(new File(v));
                    break;
                }
                case "-o": {
                    jgm.generator.getConfiguration().setOutputDirectory(new File(v));
                }
            }
        }
        jgm.run();
    }
}

