/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.TokenException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JavaVariable {
    public static final Map<String, Class> PRIMITIVES = new HashMap<String, Class>();
    private final String type;
    private final String name;

    public JavaVariable(String type, String name) {
        this.type = type == null ? null : type.replaceAll(" ", "");
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeAsNonPrimitiveType() {
        if (this.type == null) {
            return null;
        }
        if (PRIMITIVES.containsKey(this.type)) {
            return PRIMITIVES.get(this.type).getName();
        }
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasType() {
        return this.type != null && !this.type.equals("");
    }

    public static JavaVariable parse(String s) throws TokenException {
        List<JavaVariable> vars = JavaVariable.parseList(s);
        if (vars.size() != 1) {
            throw new TokenException("Invalid java variable");
        }
        return vars.get(0);
    }

    public static List<JavaVariable> parseList(String s) throws TokenException {
        s = s.trim();
        ArrayList<JavaVariable> vars = new ArrayList<JavaVariable>();
        int offset = 0;
        while (offset < s.length()) {
            String typeOrName;
            if ((offset += (typeOrName = JavaVariable.parseToken(s, offset)).length()) >= s.length() || s.charAt(offset) == ',') {
                vars.add(new JavaVariable(null, typeOrName.trim()));
            } else {
                String name = JavaVariable.parseToken(s, offset);
                offset += name.length();
                vars.add(new JavaVariable(typeOrName.trim(), name.trim()));
            }
            if (offset >= s.length()) continue;
            ++offset;
        }
        return vars;
    }

    public static String parseToken(String s, int offset) throws TokenException {
        int i;
        int begin = -1;
        int nameEnd = -1;
        boolean generic = false;
        int nestedGeneric = 0;
        boolean array = false;
        int nestedArray = 0;
        for (i = offset; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (nestedGeneric > 0) {
                if (c == '<') {
                    ++nestedGeneric;
                    continue;
                }
                if (c != '>' || --nestedGeneric > 0) continue;
                generic = true;
                continue;
            }
            if (nestedArray > 0) {
                if (RockerUtil.isWhitespace(c)) continue;
                if (c == ']') {
                    if (--nestedArray > 0) continue;
                    array = true;
                    continue;
                }
                throw new TokenException("Unexpected token '" + c + "' inside array delimiters");
            }
            if (c == '<') {
                if (generic) {
                    throw new TokenException("Unexpected token '<': generic already defined");
                }
                if (begin < 0) {
                    throw new TokenException("Unexpected token '<': generic before name");
                }
                if (array) {
                    throw new TokenException("Unexpected token '<': generic cannot be after array delimiters");
                }
                if (nameEnd < 0) {
                    nameEnd = i - 1;
                }
                ++nestedGeneric;
                continue;
            }
            if (c == '[') {
                if (begin < 0) {
                    throw new TokenException("Unexpected token '[': array before name");
                }
                if (nameEnd < 0) {
                    nameEnd = i - 1;
                }
                ++nestedArray;
                continue;
            }
            if (RockerUtil.isWhitespace(c)) {
                if (begin < 0 || nameEnd >= 0) continue;
                nameEnd = i - 1;
                continue;
            }
            if (c == ',') {
                if (nameEnd >= 0) break;
                nameEnd = i - 1;
                break;
            }
            if (begin < 0) {
                begin = i;
                continue;
            }
            if (nameEnd >= 0) break;
        }
        if (nestedGeneric > 0) {
            throw new TokenException("Invalid java variable: closing generic token '>' not found");
        }
        if (nestedArray > 0) {
            throw new TokenException("Invalid java variable: closing array token ']' not found");
        }
        if (begin < 0) {
            throw new TokenException("Invalid java variable: name part never found");
        }
        if (nameEnd < 0) {
            nameEnd = i;
        }
        return s.substring(offset, i);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.type);
        hash = 83 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVariable other = (JavaVariable)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        if (this.type == null) {
            return this.name;
        }
        return this.type + " " + this.name;
    }

    static {
        PRIMITIVES.put("boolean", Boolean.class);
        PRIMITIVES.put("byte", Byte.class);
        PRIMITIVES.put("char", Character.class);
        PRIMITIVES.put("short", Short.class);
        PRIMITIVES.put("int", Integer.class);
        PRIMITIVES.put("long", Long.class);
        PRIMITIVES.put("float", Float.class);
        PRIMITIVES.put("double", Double.class);
    }
}

