/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.compiler.GeneratorException;
import com.fizzed.rocker.compiler.JavaGenerator;
import com.fizzed.rocker.compiler.JavaSourceUtil;
import com.fizzed.rocker.compiler.RockerConfiguration;
import com.fizzed.rocker.compiler.TemplateParser;
import com.fizzed.rocker.model.SourcePosition;
import com.fizzed.rocker.model.TemplateModel;
import com.fizzed.rocker.runtime.CompileDiagnostic;
import com.fizzed.rocker.runtime.CompileDiagnosticException;
import com.fizzed.rocker.runtime.CompileUnrecoverableException;
import com.fizzed.rocker.runtime.ParserException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateCompiler {
    private static final Logger log = LoggerFactory.getLogger(TemplateCompiler.class);
    private final RockerConfiguration configuration;

    public TemplateCompiler(RockerConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<CompilationUnit> parse(List<File> templateFiles) throws ParserException, IOException {
        TemplateParser parser = new TemplateParser(this.configuration);
        ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
        for (File templateFile : templateFiles) {
            TemplateModel model = parser.parse(templateFile);
            CompilationUnit unit = new CompilationUnit();
            unit.templateFile = templateFile;
            unit.templateModel = model;
            units.add(unit);
        }
        return units;
    }

    public void generate(List<CompilationUnit> units) throws GeneratorException, IOException {
        JavaGenerator generator = new JavaGenerator(this.configuration);
        for (CompilationUnit unit : units) {
            unit.javaFile = generator.generate(unit.templateModel);
        }
    }

    public void compile(List<CompilationUnit> units) throws CompileUnrecoverableException, CompileDiagnosticException {
        URL[] classpathUrls;
        StringBuilder classpath = new StringBuilder();
        for (URL url : classpathUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            try {
                classpath.append(new File(url.toURI()).getAbsolutePath());
            }
            catch (Exception e) {
                throw new CompileUnrecoverableException("Unable to build javac classpath", (Throwable)e);
            }
        }
        this.configuration.getClassDirectory().mkdirs();
        ArrayList<String> javacOptions = new ArrayList<String>();
        javacOptions.add("-classpath");
        javacOptions.add(classpath.toString());
        javacOptions.add("-d");
        javacOptions.add(this.configuration.getClassDirectory().getAbsolutePath());
        javacOptions.add("-Xlint:unchecked");
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        HashMap<File, CompilationUnit> unitsByJavaFile = new HashMap<File, CompilationUnit>();
        for (CompilationUnit unit : units) {
            unitsByJavaFile.put(unit.javaFile.getAbsoluteFile(), unit);
        }
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(unitsByJavaFile.keySet());
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, diagnostics, javacOptions, null, compilationUnits);
        boolean success = task.call();
        int errors = 0;
        ArrayList<CompileDiagnostic> cds = new ArrayList<CompileDiagnostic>();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            JavaFileObject jfo = (JavaFileObject)diagnostic.getSource();
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            File javaFile = new File(jfo.toUri()).getAbsoluteFile();
            CompilationUnit unit = (CompilationUnit)unitsByJavaFile.get(javaFile);
            int templateLineNumber = -1;
            int templateColumnNumber = -1;
            try {
                SourcePosition sourcePos = JavaSourceUtil.findSourcePosition(javaFile, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber());
                if (sourcePos != null) {
                    templateLineNumber = sourcePos.getLineNumber();
                    templateColumnNumber = sourcePos.getPosInLine();
                }
            }
            catch (IOException sourcePos) {
                // empty catch block
            }
            CompileDiagnostic cd = new CompileDiagnostic(unit.templateFile, javaFile, (long)templateLineNumber, (long)templateColumnNumber, diagnostic.getLineNumber(), diagnostic.getColumnNumber(), diagnostic.getMessage(null));
            cds.add(cd);
            ++errors;
        }
        if (!success || errors > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to compile rocker template(s) with ").append(errors).append(" errors.");
            for (CompileDiagnostic cd : cds) {
                sb.append("\r\n");
                sb.append("[ERROR] ").append(cd.getTemplateFile());
                if (cd.getTemplateLineNumber() >= 0L) {
                    sb.append(":[").append(cd.getTemplateLineNumber()).append(",").append(cd.getTemplateColumnNumber()).append("] ");
                }
                sb.append("\r\n");
                sb.append("  java: ").append(cd.getJavaFile()).append(":[").append(cd.getJavaLineNumber()).append(",").append(cd.getJavaColumnNumber()).append("] ");
                sb.append(cd.getMessage().trim());
            }
            log.warn("{}", (Object)sb);
            throw new CompileDiagnosticException(sb.toString(), cds);
        }
    }

    public static class CompilationUnit {
        private File templateFile;
        private TemplateModel templateModel;
        private File javaFile;

        public File getTemplateFile() {
            return this.templateFile;
        }

        public TemplateModel getTemplateModel() {
            return this.templateModel;
        }

        public File getJavaFile() {
            return this.javaFile;
        }
    }
}

