/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.ForIterator;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerContent;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.compiler.GeneratorException;
import com.fizzed.rocker.compiler.PlainTextStrategy;
import com.fizzed.rocker.compiler.RockerConfiguration;
import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.WithStatementConsumerGenerator;
import com.fizzed.rocker.model.Argument;
import com.fizzed.rocker.model.BreakStatement;
import com.fizzed.rocker.model.Comment;
import com.fizzed.rocker.model.ContentClosureBegin;
import com.fizzed.rocker.model.ContentClosureEnd;
import com.fizzed.rocker.model.ContinueStatement;
import com.fizzed.rocker.model.ForBlockBegin;
import com.fizzed.rocker.model.ForBlockEnd;
import com.fizzed.rocker.model.ForStatement;
import com.fizzed.rocker.model.IfBlockBegin;
import com.fizzed.rocker.model.IfBlockElse;
import com.fizzed.rocker.model.IfBlockElseIf;
import com.fizzed.rocker.model.IfBlockEnd;
import com.fizzed.rocker.model.JavaImport;
import com.fizzed.rocker.model.JavaVariable;
import com.fizzed.rocker.model.NullTernaryExpression;
import com.fizzed.rocker.model.PlainText;
import com.fizzed.rocker.model.PostProcessorException;
import com.fizzed.rocker.model.TemplateModel;
import com.fizzed.rocker.model.TemplateModelPostProcessor;
import com.fizzed.rocker.model.TemplateUnit;
import com.fizzed.rocker.model.ValueClosureBegin;
import com.fizzed.rocker.model.ValueClosureEnd;
import com.fizzed.rocker.model.ValueExpression;
import com.fizzed.rocker.model.WithBlockBegin;
import com.fizzed.rocker.model.WithBlockElse;
import com.fizzed.rocker.model.WithBlockEnd;
import com.fizzed.rocker.model.WithStatement;
import com.fizzed.rocker.runtime.BreakException;
import com.fizzed.rocker.runtime.ContinueException;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.IterableForIterator;
import com.fizzed.rocker.runtime.Java8Iterator;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;
import com.fizzed.rocker.runtime.RockerRuntime;
import com.fizzed.rocker.runtime.WithBlock;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGenerator {
    private static final Logger log = LoggerFactory.getLogger(JavaGenerator.class);
    public static final String CRLF = "\r\n";
    public static final String TAB = "    ";
    public static final int PLAIN_TEXT_CHUNK_LENGTH = 16384;
    private final RockerConfiguration configuration;
    private PlainTextStrategy plainTextStrategy;

    public JavaGenerator(RockerConfiguration configuration) {
        this.configuration = configuration;
        this.plainTextStrategy = PlainTextStrategy.STATIC_BYTE_ARRAYS_VIA_UNLOADED_CLASS;
    }

    public RockerConfiguration getConfiguration() {
        return this.configuration;
    }

    public PlainTextStrategy getPlainTextStrategy() {
        return this.plainTextStrategy;
    }

    public void setPlainTextStrategy(PlainTextStrategy plainTextStrategy) {
        this.plainTextStrategy = plainTextStrategy;
    }

    public File generate(TemplateModel model) throws GeneratorException, IOException {
        File buildDir;
        if (this.configuration.getOutputDirectory() == null) {
            throw new NullPointerException("Output dir was null");
        }
        if (model == null) {
            throw new NullPointerException("Model was null");
        }
        Path outputPath = this.configuration.getOutputDirectory().toPath();
        Path packagePath = RockerUtil.packageNameToPath(model.getPackageName());
        if (packagePath != null) {
            outputPath = outputPath.resolve(packagePath);
        }
        if (!(buildDir = outputPath.toFile()).exists()) {
            buildDir.mkdirs();
        }
        File outputFile = new File(buildDir, model.getName() + ".java");
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));){
            this.createSourceTemplate(model, w);
            ((Writer)w).flush();
        }
        return outputFile;
    }

    public Writer tab(Writer w, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            w.append(TAB);
        }
        return w;
    }

    public String sourceRef(TemplateUnit unit) {
        return "@ " + "[" + unit.getSourceRef().getBegin().toString() + "]";
    }

    public String sourceRefLineCommaPosInLine(TemplateUnit unit) {
        return unit.getSourceRef().getBegin().getLineNumber() + ", " + unit.getSourceRef().getBegin().getPosInLine();
    }

    public void appendCommentAndSourcePositionUpdate(Writer w, int tab, TemplateUnit unit) throws IOException {
        String unitName = RockerUtil.unqualifiedClassName(unit);
        this.tab(w, tab).append("// ").append(unitName).append(" ").append(this.sourceRef(unit)).append(CRLF);
        this.tab(w, tab).append("__internal.aboutToExecutePosInTemplate(").append(this.sourceRefLineCommaPosInLine(unit)).append(");").append(CRLF);
    }

    public boolean isForIteratorType(String type) {
        return type != null && (type.equals("ForIterator") || type.equals(ForIterator.class.getName()));
    }

    public void appendArgumentMembers(TemplateModel model, Writer w, String access, boolean finalModifier, int indent) throws IOException {
        if (model.getArguments().size() > 0) {
            w.append(CRLF);
            for (Argument arg : model.getArguments()) {
                this.tab(w, indent).append("// argument ").append(this.sourceRef(arg)).append(CRLF);
                this.tab(w, indent).append(access).append(" ").append(finalModifier ? "final " : "").append(arg.getExternalType()).append(" " + arg.getName()).append(";").append(CRLF);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createSourceTemplate(TemplateModel model, Writer w) throws GeneratorException, IOException {
        if (model.getOptions().getPostProcessing() != null) {
            try {
                model = this.postProcess(model);
            }
            catch (PostProcessorException ppe) {
                throw new GeneratorException("Error during post-processing of model.", ppe);
            }
        }
        WithStatementConsumerGenerator withStatementConsumerGenerator = new WithStatementConsumerGenerator();
        int varCounter = -1;
        if (model.getPackageName() != null && !model.getPackageName().equals("")) {
            w.append("package ").append(model.getPackageName()).append(";").append(CRLF);
        }
        w.append(CRLF);
        w.append("import ").append(Generated.class.getName()).append(";").append(CRLF);
        w.append("import ").append(IOException.class.getName()).append(";").append(CRLF);
        w.append("import ").append(ForIterator.class.getName()).append(";").append(CRLF);
        w.append("import ").append(RenderingException.class.getName()).append(";").append(CRLF);
        w.append("import ").append(RockerContent.class.getName()).append(";").append(CRLF);
        w.append("import ").append(RockerOutput.class.getName()).append(";").append(CRLF);
        w.append("import ").append(DefaultRockerTemplate.class.getName()).append(";").append(CRLF);
        w.append("import ").append(PlainTextUnloadedClassLoader.class.getName()).append(";").append(CRLF);
        if (model.getImports().size() > 0) {
            for (JavaImport i : model.getImports()) {
                w.append("// import ").append(this.sourceRef(i)).append(CRLF);
                w.append("import ").append(i.getStatement()).append(";").append(CRLF);
            }
        }
        w.append(CRLF);
        w.append("/*").append(CRLF);
        w.append(" * Auto generated code to render template ").append(model.getPackageName().replace('.', '/')).append("/").append(model.getTemplateName()).append(CRLF);
        w.append(" * Do not edit this file. Changes will eventually be overwritten by Rocker parser!").append(CRLF);
        w.append(" */").append(CRLF);
        int indent = 0;
        this.tab(w, indent).append("@Generated(\"com.fizzed.rocker.compiler.JavaGenerator\") @SuppressWarnings(\"unused\")").append(CRLF);
        this.tab(w, indent).append("public class ").append(model.getName()).append(" extends ").append(model.getOptions().getExtendsModelClass()).append(" {").append(CRLF);
        w.append(CRLF);
        this.tab(w, ++indent).append("static public final ").append(ContentType.class.getCanonicalName()).append(" CONTENT_TYPE = ").append(ContentType.class.getCanonicalName()).append(".").append(model.getContentType().toString()).append(";").append(CRLF);
        this.tab(w, indent).append("static public final String TEMPLATE_NAME = \"").append(model.getTemplateName()).append("\";").append(CRLF);
        this.tab(w, indent).append("static public final String TEMPLATE_PACKAGE_NAME = \"").append(model.getPackageName()).append("\";").append(CRLF);
        this.tab(w, indent).append("static public final String HEADER_HASH = \"").append(model.createHeaderHash() + "").append("\";").append(CRLF);
        if (!model.getOptions().getOptimize().booleanValue()) {
            this.tab(w, indent).append("static public final long MODIFIED_AT = ").append(model.getModifiedAt() + "").append("L;").append(CRLF);
        }
        this.tab(w, indent).append("static public final String[] ARGUMENT_NAMES = {");
        StringBuilder argNameList = new StringBuilder();
        for (Argument argument : model.getArgumentsWithoutRockerBody()) {
            if (argNameList.length() > 0) {
                argNameList.append(",");
            }
            argNameList.append(" \"").append(argument.getExternalName()).append("\"");
        }
        w.append(argNameList).append(" };").append(CRLF);
        this.appendArgumentMembers(model, w, "private", false, indent);
        if (model.getArguments().size() > 0) {
            for (Argument argument : model.getArguments()) {
                w.append(CRLF);
                this.tab(w, indent).append("public ").append(model.getName()).append(" ").append(argument.getExternalName()).append("(" + argument.getExternalType()).append(" ").append(argument.getName()).append(") {").append(CRLF);
                this.tab(w, indent + 1).append("this.").append(argument.getName()).append(" = ").append(argument.getName()).append(";").append(CRLF);
                this.tab(w, indent + 1).append("return this;").append(CRLF);
                this.tab(w, indent).append("}").append(CRLF);
                w.append(CRLF);
                this.tab(w, indent).append("public ").append(argument.getExternalType()).append(" ").append(argument.getExternalName()).append("() {").append(CRLF);
                this.tab(w, indent + 1).append("return this.").append(argument.getName()).append(";").append(CRLF);
                this.tab(w, indent).append("}").append(CRLF);
            }
        }
        w.append(CRLF);
        this.tab(w, indent).append("static public ").append(model.getName()).append(" template(");
        if (model.getArguments().size() > 0) {
            int i = 0;
            for (Argument argument : model.getArgumentsWithoutRockerBody()) {
                if (i != 0) {
                    w.append(", ");
                }
                w.append(argument.getType()).append(" ").append(argument.getName());
                ++i;
            }
        }
        w.append(") {").append(CRLF);
        this.tab(w, indent + 1).append("return new ").append(model.getName()).append("()");
        if (model.getArguments().size() > 0) {
            int i = 0;
            for (Argument argument : model.getArgumentsWithoutRockerBody()) {
                w.append(CRLF);
                this.tab(w, indent + 2).append(".").append(argument.getName()).append("(").append(argument.getName()).append(")");
                ++i;
            }
        }
        w.append(";").append(CRLF);
        this.tab(w, indent).append("}").append(CRLF);
        w.append(CRLF);
        this.tab(w, indent).append("@Override").append(CRLF);
        this.tab(w, indent).append("protected DefaultRockerTemplate buildTemplate() throws RenderingException {").append(CRLF);
        if (model.getOptions().getOptimize().booleanValue()) {
            this.tab(w, indent + 1).append("// optimized for performance (via rocker.optimize flag; no auto reloading)").append(CRLF);
            this.tab(w, indent + 1).append("return new Template(this);").append(CRLF);
        } else {
            this.tab(w, indent + 1).append("// optimized for convenience (runtime auto reloading enabled if rocker.reloading=true)").append(CRLF);
            this.tab(w, indent + 1).append("return ").append(RockerRuntime.class.getCanonicalName()).append(".getInstance().getBootstrap().template(this.getClass(), this);").append(CRLF);
        }
        this.tab(w, indent).append("}").append(CRLF);
        w.append(CRLF);
        this.tab(w, indent).append("static public class Template extends ").append(model.getOptions().getExtendsClass());
        w.append(" {").append(CRLF);
        ++indent;
        LinkedHashMap<String, LinkedHashMap<String, String>> plainTextMap = model.createPlainTextMap(16384);
        if (!plainTextMap.isEmpty()) {
            w.append(CRLF);
            for (String string : plainTextMap.keySet()) {
                this.tab(w, indent).append("// ").append(StringUtils.abbreviate((String)RockerUtil.ESCAPE_JAVA.translate((CharSequence)string), (int)500)).append(CRLF);
                for (Map.Entry<String, String> entry : plainTextMap.get(string).entrySet()) {
                    if (this.plainTextStrategy == PlainTextStrategy.STATIC_STRINGS) {
                        this.tab(w, indent).append("static private final String ").append(entry.getKey()).append(" = \"").append(StringEscapeUtils.escapeJava((String)entry.getValue())).append("\";").append(CRLF);
                        continue;
                    }
                    if (this.plainTextStrategy != PlainTextStrategy.STATIC_BYTE_ARRAYS_VIA_UNLOADED_CLASS) continue;
                    this.tab(w, indent).append("static private final byte[] ").append(entry.getKey()).append(";").append(CRLF);
                }
            }
            if (this.plainTextStrategy == PlainTextStrategy.STATIC_BYTE_ARRAYS_VIA_UNLOADED_CLASS) {
                w.append(CRLF);
                this.tab(w, indent).append("static {").append(CRLF);
                String string = RockerUtil.unqualifiedClassName(PlainTextUnloadedClassLoader.class);
                this.tab(w, indent + 1).append(string).append(" loader = ").append(string).append(".tryLoad(").append(model.getName()).append(".class.getClassLoader(), ").append(model.getName()).append(".class.getName()").append(" + \"$PlainText\", \"").append(model.getOptions().getTargetCharset()).append("\");").append(CRLF);
                for (String plainText : plainTextMap.keySet()) {
                    for (Map.Entry<String, String> entry : plainTextMap.get(plainText).entrySet()) {
                        if (this.plainTextStrategy != PlainTextStrategy.STATIC_BYTE_ARRAYS_VIA_UNLOADED_CLASS) continue;
                        this.tab(w, indent + 1).append(entry.getKey()).append(" = loader.tryGet(\"").append(entry.getKey()).append("\");").append(CRLF);
                    }
                }
                this.tab(w, indent).append("}").append(CRLF);
            }
        }
        this.appendArgumentMembers(model, w, "protected", true, indent);
        w.append(CRLF);
        this.tab(w, indent).append("public Template(").append(model.getName()).append(" model) {").append(CRLF);
        this.tab(w, indent + 1).append("super(model);").append(CRLF);
        this.tab(w, indent + 1).append("__internal.setCharset(\"").append(model.getOptions().getTargetCharset()).append("\");").append(CRLF);
        this.tab(w, indent + 1).append("__internal.setContentType(CONTENT_TYPE);").append(CRLF);
        this.tab(w, indent + 1).append("__internal.setTemplateName(TEMPLATE_NAME);").append(CRLF);
        this.tab(w, indent + 1).append("__internal.setTemplatePackageName(TEMPLATE_PACKAGE_NAME);").append(CRLF);
        for (Argument argument : model.getArguments()) {
            this.tab(w, indent + 1).append("this.").append(argument.getName()).append(" = model.").append(argument.getExternalName()).append("();").append(CRLF);
        }
        this.tab(w, indent).append("}").append(CRLF);
        w.append(CRLF);
        this.tab(w, indent).append("@Override").append(CRLF);
        this.tab(w, indent).append("protected void __doRender() throws IOException, RenderingException {").append(CRLF);
        boolean bl = true;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        for (TemplateUnit templateUnit : model.getUnits()) {
            Object stmt;
            void var8_25;
            if (templateUnit instanceof Comment) continue;
            this.appendCommentAndSourcePositionUpdate(w, (int)(var8_25 + indent), templateUnit);
            if (templateUnit instanceof PlainText) {
                PlainText plainText = (PlainText)templateUnit;
                LinkedHashMap<String, String> chunks = plainTextMap.get(plainText.getText());
                for (String chunkName : chunks.keySet()) {
                    this.tab(w, (int)(var8_25 + indent)).append("__internal.writeValue(").append(chunkName).append(");").append(CRLF);
                }
                continue;
            }
            if (templateUnit instanceof ValueExpression) {
                ValueExpression valueExpression = (ValueExpression)templateUnit;
                this.tab(w, (int)(var8_25 + indent)).append("__internal.renderValue(").append(valueExpression.getExpression()).append(", ").append("" + valueExpression.isNullSafe()).append(");").append(CRLF);
                continue;
            }
            if (templateUnit instanceof NullTernaryExpression) {
                NullTernaryExpression nullTernaryExpression = (NullTernaryExpression)templateUnit;
                this.tab(w, (int)(var8_25 + indent)).append("{").append(CRLF);
                this.tab(w, (int)(var8_25 + indent + true)).append("final Object __v = ").append(nullTernaryExpression.getLeftExpression()).append(";").append(CRLF);
                this.tab(w, (int)(var8_25 + indent + true)).append("if (__v != null) { __internal.renderValue(__v, false); }").append(CRLF);
                if (nullTernaryExpression.getRightExpression() != null) {
                    this.tab(w, (int)(var8_25 + indent + true)).append("else {__internal.renderValue(").append(nullTernaryExpression.getRightExpression()).append(", true); }").append(CRLF);
                }
                this.tab(w, (int)(var8_25 + indent)).append("}").append(CRLF);
                continue;
            }
            if (templateUnit instanceof ValueClosureBegin) {
                ValueClosureBegin valueClosureBegin = (ValueClosureBegin)templateUnit;
                this.tab(w, (int)(var8_25 + indent)).append("__internal.renderValue(").append(valueClosureBegin.getExpression()).append(".__body(");
                if (RockerUtil.isJava8Plus(model)) {
                    w.append("() -> {").append(CRLF);
                    ++var8_25;
                    arrayDeque.push("}), false);");
                    continue;
                }
                w.append("new ").append(RockerUtil.unqualifiedClassName(RockerContent.class)).append("() {").append(CRLF);
                arrayDeque.push("}), false);");
                this.tab(w, (int)(++var8_25 + indent)).append("@Override").append(CRLF);
                this.tab(w, (int)(var8_25 + indent)).append("public void render() throws IOException, RenderingException {").append(CRLF);
                ++var8_25;
                arrayDeque.push("}");
                continue;
            }
            if (templateUnit instanceof ValueClosureEnd) {
                if (RockerUtil.isJava8Plus(model)) {
                    this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // value closure end ").append(this.sourceRef(templateUnit)).append(CRLF);
                    continue;
                }
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(CRLF);
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // value closure end ").append(this.sourceRef(templateUnit)).append(CRLF);
                continue;
            }
            if (templateUnit instanceof ContentClosureBegin) {
                ContentClosureBegin contentClosureBegin = (ContentClosureBegin)templateUnit;
                this.tab(w, (int)(var8_25 + indent)).append("RockerContent ").append(contentClosureBegin.getIdentifier()).append(" = ");
                if (RockerUtil.isJava8Plus(model)) {
                    w.append("() -> {").append(CRLF);
                    ++var8_25;
                    arrayDeque.push("};");
                    continue;
                }
                w.append("new ").append(RockerUtil.unqualifiedClassName(RockerContent.class)).append("() {").append(CRLF);
                arrayDeque.push("};");
                this.tab(w, (int)(++var8_25 + indent)).append("@Override").append(CRLF);
                this.tab(w, (int)(var8_25 + indent)).append("public void render() throws IOException, RenderingException {").append(CRLF);
                ++var8_25;
                arrayDeque.push("}");
                continue;
            }
            if (templateUnit instanceof ContentClosureEnd) {
                if (RockerUtil.isJava8Plus(model)) {
                    this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // content closure end ").append(this.sourceRef(templateUnit)).append(CRLF);
                    continue;
                }
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(CRLF);
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // content closure end ").append(this.sourceRef(templateUnit)).append(CRLF);
                continue;
            }
            if (templateUnit instanceof IfBlockBegin) {
                IfBlockBegin ifBlockBegin = (IfBlockBegin)templateUnit;
                this.tab(w, (int)(var8_25 + indent)).append("if ").append(ifBlockBegin.getExpression()).append(" {").append(CRLF);
                arrayDeque.push("}");
                ++var8_25;
                continue;
            }
            if (templateUnit instanceof IfBlockElseIf) {
                IfBlockElseIf ifBlockElseIf = (IfBlockElseIf)templateUnit;
                this.tab(w, (int)(--var8_25 + indent)).append("} else if ").append(ifBlockElseIf.getExpression()).append(" {").append(CRLF);
                ++var8_25;
                continue;
            }
            if (templateUnit instanceof IfBlockElse) {
                this.tab(w, (int)(--var8_25 + indent)).append("} else {").append(" // else ").append(this.sourceRef(templateUnit)).append(CRLF);
                ++var8_25;
                continue;
            }
            if (templateUnit instanceof IfBlockEnd) {
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // if end ").append(this.sourceRef(templateUnit)).append(CRLF);
                continue;
            }
            if (templateUnit instanceof WithBlockBegin) {
                JavaVariable variable;
                WithStatement.VariableWithExpression var;
                int i;
                WithBlockBegin withBlockBegin = (WithBlockBegin)templateUnit;
                stmt = withBlockBegin.getStatement();
                String statementConsumerName = withStatementConsumerGenerator.register((WithStatement)stmt);
                List<WithStatement.VariableWithExpression> variables = ((WithStatement)stmt).getVariables();
                if (RockerUtil.isJava8Plus(model)) {
                    this.tab(w, (int)(var8_25 + indent)).append(variables.size() == 1 ? RockerUtil.qualifiedClassName(WithBlock.class) : "WithBlocksGenerated0").append(".with(");
                    for (i = 0; i < variables.size(); ++i) {
                        var = variables.get(i);
                        if (i > 0) {
                            w.append(", ");
                        }
                        w.append(var.getValueExpression());
                    }
                    w.append(", ").append(((WithStatement)stmt).isNullSafe() + "").append(", (");
                    for (i = 0; i < variables.size(); ++i) {
                        var = variables.get(i);
                        if (i > 0) {
                            w.append(", ");
                        }
                        w.append(var.getVariable().getName());
                    }
                    w.append(") -> {").append(CRLF);
                    ++var8_25;
                    arrayDeque.push("});");
                    continue;
                }
                this.tab(w, (int)(var8_25 + indent)).append(variables.size() == 1 ? RockerUtil.qualifiedClassName(WithBlock.class) : "WithBlocksGenerated0").append(".with(");
                for (i = 0; i < variables.size(); ++i) {
                    var = variables.get(i);
                    if (i > 0) {
                        w.append(", ");
                    }
                    w.append(var.getValueExpression());
                }
                w.append(", ").append(((WithStatement)stmt).isNullSafe() + "").append(", (new ").append(statementConsumerName).append('<');
                for (i = 0; i < variables.size(); ++i) {
                    variable = variables.get(i).getVariable();
                    if (i > 0) {
                        w.append(", ");
                    }
                    w.append(variable.getType());
                }
                w.append(">() {").append(CRLF);
                this.tab(w, (int)(var8_25 + indent + true)).append("@Override public void accept(");
                for (i = 0; i < variables.size(); ++i) {
                    variable = variables.get(i).getVariable();
                    if (i > 0) {
                        w.append(", ");
                    }
                    w.append("final ").append(variable.toString());
                }
                w.append(") throws IOException {").append(CRLF);
                ++var8_25;
                arrayDeque.push("}}));");
                continue;
            }
            if (templateUnit instanceof WithBlockElse) {
                --var8_25;
                if (RockerUtil.isJava8Plus(model)) {
                    this.tab(w, (int)(var8_25 + indent)).append("}, () -> {").append(CRLF);
                } else {
                    this.tab(w, (int)(var8_25 + indent)).append("}}), (new ").append(RockerUtil.qualifiedClassName(WithBlock.Consumer0.class)).append("() { ").append("@Override public void accept() throws IOException {").append(CRLF);
                }
                ++var8_25;
                continue;
            }
            if (templateUnit instanceof WithBlockEnd) {
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // with end ").append(this.sourceRef(templateUnit)).append(CRLF);
                continue;
            }
            if (templateUnit instanceof ForBlockBegin) {
                ForBlockBegin forBlockBegin = (ForBlockBegin)templateUnit;
                stmt = forBlockBegin.getStatement();
                this.tab(w, (int)(var8_25 + indent)).append("try {").append(CRLF);
                ++var8_25;
                if (((ForStatement)stmt).getForm() == ForStatement.Form.GENERAL) {
                    this.tab(w, (int)(var8_25 + indent)).append("for ").append(forBlockBegin.getExpression()).append(" {").append(CRLF);
                    arrayDeque.push("}");
                } else if (((ForStatement)stmt).getForm() == ForStatement.Form.ENHANCED) {
                    if (((ForStatement)stmt).hasAnyUntypedArguments() && RockerUtil.isJava8Plus(model)) {
                        String localVars = "";
                        for (JavaVariable arg : ((ForStatement)stmt).getArguments()) {
                            if (localVars.length() != 0) {
                                localVars = localVars + ",";
                            }
                            localVars = localVars + arg.getName();
                        }
                        this.tab(w, (int)(var8_25 + indent)).append(Java8Iterator.class.getName()).append(".forEach(").append(((ForStatement)stmt).getValueExpression()).append(", (").append(localVars).append(") -> {").append(CRLF);
                        arrayDeque.push("});");
                    } else {
                        boolean forIterator = this.isForIteratorType(((ForStatement)stmt).getArguments().get(0).getType());
                        int collectionCount = forIterator ? 2 : 1;
                        int mapCount = forIterator ? 3 : 2;
                        String iterateeType = null;
                        String valueExpression = null;
                        if (((ForStatement)stmt).getArguments().size() == collectionCount) {
                            iterateeType = ((ForStatement)stmt).getArguments().get(collectionCount - 1).getTypeAsNonPrimitiveType();
                            valueExpression = ((ForStatement)stmt).getValueExpression();
                        } else if (((ForStatement)stmt).getArguments().size() == mapCount) {
                            iterateeType = "java.util.Map.Entry<" + ((ForStatement)stmt).getArguments().get(mapCount - 2).getTypeAsNonPrimitiveType() + "," + ((ForStatement)stmt).getArguments().get(mapCount - 1).getTypeAsNonPrimitiveType() + ">";
                            valueExpression = ((ForStatement)stmt).getValueExpression() + ".entrySet()";
                        }
                        String forIteratorVarName = "__forIterator" + ++varCounter;
                        this.tab(w, (int)(var8_25 + indent)).append("final ").append(IterableForIterator.class.getName()).append("<").append(iterateeType).append(">").append(" ").append(forIteratorVarName).append(" = new ").append(IterableForIterator.class.getName()).append("<").append(iterateeType).append(">").append("(").append(valueExpression).append(");").append(CRLF);
                        this.tab(w, (int)(var8_25 + indent)).append("while (").append(forIteratorVarName).append(".hasNext()) {").append(CRLF);
                        if (forIterator) {
                            this.tab(w, (int)(var8_25 + indent + true)).append("final ").append(ForIterator.class.getName()).append(" ").append(((ForStatement)stmt).getArguments().get(0).getName()).append(" = ").append(forIteratorVarName).append(";").append(CRLF);
                        }
                        if (((ForStatement)stmt).getArguments().size() == collectionCount) {
                            this.tab(w, (int)(var8_25 + indent + true)).append("final ").append(((ForStatement)stmt).getArguments().get(collectionCount - 1).toString()).append(" = ").append(forIteratorVarName).append(".next();").append(CRLF);
                        } else if (((ForStatement)stmt).getArguments().size() == mapCount) {
                            String entryVarName = "__entry" + ++varCounter;
                            this.tab(w, (int)(var8_25 + indent + true)).append("final ").append(iterateeType).append(" ").append(entryVarName).append(" = ").append(forIteratorVarName).append(".next();").append(CRLF);
                            this.tab(w, (int)(var8_25 + indent + true)).append("final ").append(((ForStatement)stmt).getArguments().get(mapCount - 2).toString()).append(" = ").append(entryVarName).append(".getKey();").append(CRLF);
                            this.tab(w, (int)(var8_25 + indent + true)).append("final ").append(((ForStatement)stmt).getArguments().get(mapCount - 1).toString()).append(" = ").append(entryVarName).append(".getValue();").append(CRLF);
                        } else {
                            throw new GeneratorException("Unsupported number of arguments for for loop");
                        }
                        arrayDeque.push("}");
                    }
                }
                this.tab(w, (int)(++var8_25 + indent)).append("try {").append(CRLF);
                ++var8_25;
                continue;
            }
            if (templateUnit instanceof ForBlockEnd) {
                this.tab(w, (int)(--var8_25 + indent)).append("} catch (").append(ContinueException.class.getCanonicalName()).append(" e) {").append(CRLF);
                this.tab(w, (int)(var8_25 + indent + true)).append("// support for continuing for loops").append(CRLF);
                this.tab(w, (int)(var8_25 + indent)).append("}").append(CRLF);
                this.tab(w, (int)(--var8_25 + indent)).append((CharSequence)arrayDeque.pop()).append(" // for end ").append(this.sourceRef(templateUnit)).append(CRLF);
                this.tab(w, (int)(--var8_25 + indent)).append("} catch (").append(BreakException.class.getCanonicalName()).append(" e) {").append(CRLF);
                this.tab(w, (int)(var8_25 + indent + true)).append("// support for breaking for loops").append(CRLF);
                this.tab(w, (int)(var8_25 + indent)).append("}").append(CRLF);
                continue;
            }
            if (templateUnit instanceof BreakStatement) {
                this.tab(w, (int)(var8_25 + indent)).append("__internal.throwBreakException();").append(CRLF);
                continue;
            }
            if (!(templateUnit instanceof ContinueStatement)) continue;
            this.tab(w, (int)(var8_25 + indent)).append("__internal.throwContinueException();").append(CRLF);
        }
        this.tab(w, indent).append("}").append(CRLF);
        this.tab(w, --indent).append("}").append(CRLF);
        withStatementConsumerGenerator.generate(this, w);
        if (this.plainTextStrategy == PlainTextStrategy.STATIC_BYTE_ARRAYS_VIA_UNLOADED_CLASS && !plainTextMap.isEmpty()) {
            w.append(CRLF);
            this.tab(w, indent).append("private static class PlainText {").append(CRLF);
            w.append(CRLF);
            for (String string : plainTextMap.keySet()) {
                for (Map.Entry<String, String> chunk : plainTextMap.get(string).entrySet()) {
                    this.tab(w, indent + 1).append("static private final String ").append(chunk.getKey()).append(" = \"").append(StringEscapeUtils.escapeJava((String)chunk.getValue())).append("\";").append(CRLF);
                }
            }
            w.append(CRLF);
            this.tab(w, indent).append("}").append(CRLF);
        }
        w.append(CRLF);
        w.append("}").append(CRLF);
    }

    private TemplateModel postProcess(TemplateModel templateModel) throws PostProcessorException {
        ArrayList<String> postProcessorClassNames = new ArrayList<String>();
        if (this.getConfiguration().getOptions().getPostProcessing() != null) {
            postProcessorClassNames.addAll(Arrays.asList(this.getConfiguration().getOptions().getPostProcessing()));
        }
        postProcessorClassNames.addAll(Arrays.asList(templateModel.getOptions().getPostProcessing()));
        for (int i = 0; i < postProcessorClassNames.size(); ++i) {
            String ppClassName = (String)postProcessorClassNames.get(i);
            try {
                Class<?> ppClass = Class.forName(ppClassName);
                TemplateModelPostProcessor postProcessor = (TemplateModelPostProcessor)ppClass.newInstance();
                log.debug("Running post-processor {} on template {} at index {}.", new Object[]{postProcessor.getClass().getName(), templateModel.getName(), i});
                templateModel = postProcessor.process(templateModel, i);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new PostProcessorException("Post-Processor class not found (" + ppClassName + ").", e);
            }
            catch (InstantiationException e) {
                throw new PostProcessorException("Could not instantiate Post-Processor (" + ppClassName + ").", e);
            }
            catch (IllegalAccessException e) {
                throw new PostProcessorException("Illegal access for Post-Processor (" + ppClassName + ").", e);
            }
        }
        return templateModel;
    }
}

