/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.reload;

import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.TemplateBindException;
import com.fizzed.rocker.TemplateNotFoundException;
import com.fizzed.rocker.compiler.GeneratorException;
import com.fizzed.rocker.compiler.RockerConfiguration;
import com.fizzed.rocker.compiler.TemplateCompiler;
import com.fizzed.rocker.reload.RockerClassLoader;
import com.fizzed.rocker.runtime.CompileDiagnosticException;
import com.fizzed.rocker.runtime.CompileUnrecoverableException;
import com.fizzed.rocker.runtime.DefaultRockerBootstrap;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.ParserException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingRockerBootstrap
extends DefaultRockerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ReloadingRockerBootstrap.class);
    private final RockerConfiguration configuration = new RockerConfiguration();
    private final ConcurrentHashMap<String, String> models = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LoadedTemplate> templates = new ConcurrentHashMap();
    private RockerClassLoader classLoader = this.buildClassLoader();

    public RockerConfiguration getConfiguration() {
        return this.configuration;
    }

    private RockerClassLoader buildClassLoader() {
        return new RockerClassLoader(this, ReloadingRockerBootstrap.class.getClassLoader());
    }

    public boolean isReloadableClass(String className) {
        if (this.models.containsKey(className)) {
            return true;
        }
        int pos = className.indexOf(36);
        if (pos < 0) {
            return false;
        }
        String modelClassName = className.substring(0, pos);
        return this.templates.containsKey(modelClassName);
    }

    public File getTemplateFile(String templatePackageName, String templateName) {
        File templateFileDirectory = new File(this.configuration.getTemplateDirectory(), templatePackageName.replace('.', '/'));
        return new File(templateFileDirectory, templateName);
    }

    private long getModelClassModifiedAt(Class modelType) throws RenderingException {
        try {
            Field f = modelType.getField("MODIFIED_AT");
            return f.getLong(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RenderingException("Unable to read MODIFIED_AT static field from class " + modelType.getName());
        }
    }

    private String getModelClassHeaderHash(Class modelType) throws RenderingException {
        try {
            Field f = modelType.getField("HEADER_HASH");
            return (String)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RenderingException("Unable to read HEADER_HASH static field from class " + modelType.getName());
        }
    }

    private String getModelClassTemplatePackageName(Class modelType) throws RenderingException {
        try {
            Field f = modelType.getField("TEMPLATE_PACKAGE_NAME");
            return (String)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RenderingException("Unable to read TEMPLATE_PACKAGE_NAME static field from class " + modelType.getName());
        }
    }

    private String getModelClassTemplateName(Class modelType) throws RenderingException {
        try {
            Field f = modelType.getField("TEMPLATE_NAME");
            return (String)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RenderingException("Unable to read TEMPLATE_NAME static field from class " + modelType.getName());
        }
    }

    public DefaultRockerTemplate template(Class modelType, DefaultRockerModel model) throws RenderingException {
        LoadedTemplate template = this.templates.get(modelType.getName());
        if (template == null) {
            String templatePackageName = this.getModelClassTemplatePackageName(modelType);
            String templateName = this.getModelClassTemplateName(modelType);
            long modifiedAt = this.getModelClassModifiedAt(modelType);
            String headerHash = this.getModelClassHeaderHash(modelType);
            File templateFile = this.getTemplateFile(templatePackageName, templateName);
            if (!templateFile.exists()) {
                log.warn("{}: does not exist for model {}. Unable to check if reload required", (Object)templateFile, (Object)modelType.getCanonicalName());
                return this.buildTemplate(modelType, model, this.classLoader);
            }
            template = new LoadedTemplate();
            template.file = templateFile;
            template.modifiedAt = modifiedAt;
            template.headerHash = headerHash;
            this.templates.put(modelType.getName(), template);
        } else if (!template.file.exists()) {
            log.warn("{}: no longer exists for model {} (did you delete it?)", (Object)template.file, (Object)modelType.getCanonicalName());
            return this.buildTemplate(modelType, model, this.classLoader);
        }
        this.compileIfNeeded(template, true);
        return this.buildTemplate(modelType, model, this.classLoader);
    }

    public RockerModel model(String templatePath) throws TemplateNotFoundException, TemplateBindException {
        String modelClassName = DefaultRockerBootstrap.templatePathToClassName((String)templatePath);
        LoadedTemplate template = this.templates.get(modelClassName);
        RockerModel initialModel = null;
        if (template == null) {
            File templateFile = new File(this.configuration.getTemplateDirectory(), templatePath);
            if (!templateFile.exists()) {
                log.warn("{}: does not exist. Unable to check if reload required", (Object)templateFile);
                return this.buildModel(templatePath, this.classLoader);
            }
            template = new LoadedTemplate();
            template.file = templateFile;
            template.modifiedAt = -1L;
            this.templates.put(modelClassName, template);
            this.models.put(modelClassName, "");
            try {
                initialModel = this.buildModel(templatePath, this.classLoader);
                template.modifiedAt = this.getModelClassModifiedAt(initialModel.getClass());
                template.headerHash = this.getModelClassHeaderHash(initialModel.getClass());
            }
            catch (Exception exception) {}
        } else if (!template.file.exists()) {
            log.warn("{}: no longer exists for model {} (did you delete it?)", (Object)template.file, (Object)modelClassName);
            return this.buildModel(templatePath, this.classLoader);
        }
        boolean recompiled = this.compileIfNeeded(template, false);
        if (initialModel != null && !recompiled) {
            return initialModel;
        }
        return this.buildModel(templatePath, this.classLoader);
    }

    public boolean compileIfNeeded(LoadedTemplate template, boolean verifyHeaderHash) {
        long modifiedAt = template.file.lastModified();
        if (modifiedAt != template.modifiedAt) {
            log.info("Rocker template change detected [{}]", (Object)template.file);
            TemplateCompiler compiler = new TemplateCompiler(this.configuration);
            try {
                long start = System.currentTimeMillis();
                List<TemplateCompiler.CompilationUnit> units = compiler.parse(Arrays.asList(template.file));
                TemplateCompiler.CompilationUnit unit = units.get(0);
                String newHeaderHash = unit.getTemplateModel().createHeaderHash() + "";
                if (verifyHeaderHash && !newHeaderHash.equals(template.headerHash)) {
                    log.debug("current header hash " + template.headerHash + "; new header hash " + newHeaderHash);
                    String templatePath = unit.getTemplateModel().getPackageName().replace('.', '/');
                    throw new RenderingException(1, 1, unit.getTemplateModel().getTemplateName(), templatePath, "Interface (e.g. arguments/imports) were modified. Unable to safely hot reload. Do a fresh project build and JVM restart.", null);
                }
                compiler.generate(units);
                compiler.compile(units);
                long stop = System.currentTimeMillis();
                log.info("Rocker compiled " + units.size() + " templates in " + (stop - start) + " ms");
                template.modifiedAt = modifiedAt;
                template.headerHash = newHeaderHash;
            }
            catch (CompileDiagnosticException | CompileUnrecoverableException | ParserException e) {
                throw e;
            }
            catch (GeneratorException | IOException e) {
                throw new RenderingException("Unable to compile rocker template", (Throwable)e);
            }
            this.classLoader = this.buildClassLoader();
            return true;
        }
        return false;
    }

    public static class LoadedTemplate {
        public File file;
        public long modifiedAt;
        public String headerHash;
    }
}

