/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.model.JavaVariable;
import com.fizzed.rocker.model.SourceRef;
import com.fizzed.rocker.model.TemplateUnit;
import java.util.Objects;

public class Argument
extends TemplateUnit {
    private final JavaVariable variable;

    public Argument(SourceRef sourceRef, JavaVariable variable) {
        super(sourceRef);
        this.variable = variable;
    }

    public Argument(SourceRef sourceRef, String type, String name) {
        super(sourceRef);
        this.variable = new JavaVariable(type, name);
    }

    public String getType() {
        return this.variable.getType();
    }

    public String getName() {
        return this.variable.getName();
    }

    public boolean isRockerBodyType() {
        return this.variable.getType().equals("RockerBody");
    }

    public String getExternalType() {
        if (this.isRockerBodyType()) {
            return "RockerContent";
        }
        return this.getType();
    }

    public String getExternalName() {
        if (this.isRockerBodyType()) {
            return "__body";
        }
        return this.getName();
    }

    @Override
    public boolean isBlockLevel() {
        return true;
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Argument other = (Argument)obj;
        return Objects.equals(this.variable, other.variable);
    }
}

