/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.model.SourcePosition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class JavaSourceUtil {
    public static SourcePosition findSourcePosition(File javaFile, int lineNumber, int columnNumber) throws IOException {
        String[] lines = new String[3];
        int currentLineNumber = 1;
        try (BufferedReader br = new BufferedReader(new FileReader(javaFile));){
            String line;
            while ((line = br.readLine()) != null) {
                lines[0] = lines[1];
                lines[1] = lines[2];
                lines[2] = line;
                if (lineNumber == currentLineNumber) {
                    break;
                }
                ++currentLineNumber;
            }
        }
        if (lineNumber != currentLineNumber) {
            return null;
        }
        SourcePosition pos0 = JavaSourceUtil.findSourcePositionInComment(lines[1]);
        if (pos0 != null) {
            return pos0;
        }
        SourcePosition pos1 = JavaSourceUtil.findSourcePositionInComment(lines[0]);
        return pos1;
    }

    public static SourcePosition findSourcePositionInComment(String line) {
        if (line == null) {
            return null;
        }
        if (!(line = line.trim()).startsWith("// ")) {
            return null;
        }
        int pos = line.indexOf(" @ [");
        if (pos < 0) {
            return null;
        }
        int end = line.indexOf("]", pos);
        if (end < 0) {
            return null;
        }
        String sourceRef = line.substring(pos + 4, end);
        String[] sourceRefs = sourceRef.split(":");
        if (sourceRefs.length != 2) {
            return null;
        }
        try {
            int lineNumber = Integer.valueOf(sourceRefs[0]);
            int columnNumber = Integer.valueOf(sourceRefs[1]);
            return new SourcePosition(lineNumber, columnNumber, -1);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

