/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.compiler.RockerOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RockerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RockerConfiguration.class);
    public static final String TEMPLATE_DIR = "rocker.template.dir";
    public static final String OUTPUT_DIR = "rocker.output.dir";
    public static final String CLASS_DIR = "rocker.class.dir";
    public static final String OPTION_PREFIX = "rocker.option.";
    private File templateDirectory = new File("src/main/resources/rocker");
    private File outputDirectory = new File("target/generated-sources/rocker");
    private File classDirectory = new File("target/classes");
    private RockerOptions options = new RockerOptions();

    public RockerConfiguration() {
        this.mergeFromClassPath();
        this.merge(System.getProperties());
    }

    public final void mergeFromClassPath() {
        InputStream is = this.getClass().getResourceAsStream("/rocker-compiler.conf");
        if (is != null) {
            Properties properties = new Properties();
            try {
                properties.load(is);
                this.merge(properties);
            }
            catch (Exception e) {
                log.warn("Unable to load /rocker-compiler.conf from classpath", (Throwable)e);
            }
        }
    }

    public final void merge(Properties properties) {
        if (properties.containsKey(TEMPLATE_DIR)) {
            this.templateDirectory = new File(properties.getProperty(TEMPLATE_DIR));
            log.debug("templateDirectory = " + this.templateDirectory);
        }
        if (properties.containsKey(OUTPUT_DIR)) {
            this.outputDirectory = new File(properties.getProperty(OUTPUT_DIR));
            log.debug("outputDirectory = " + this.outputDirectory);
        }
        if (properties.containsKey(CLASS_DIR)) {
            this.classDirectory = new File(properties.getProperty(CLASS_DIR));
            log.debug("classDirectory = " + this.classDirectory);
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!name.startsWith(OPTION_PREFIX)) continue;
            String optionName = name.replace(OPTION_PREFIX, "");
            String optionValue = properties.getProperty(name);
            if (optionValue == null) continue;
            try {
                log.debug("option " + optionName + " = " + optionValue);
                this.options.set(optionName, optionValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Property " + name + " invalid: " + e.getMessage(), e);
            }
        }
    }

    public void write(File file) throws IOException {
        Properties properties = new Properties();
        properties.put(TEMPLATE_DIR, this.templateDirectory.getPath());
        properties.put(OUTPUT_DIR, this.outputDirectory.getPath());
        properties.put(CLASS_DIR, this.classDirectory.getPath());
        this.options.write(properties);
        try (FileOutputStream fos = new FileOutputStream(file);){
            properties.store(fos, OUTPUT_DIR);
        }
    }

    public File getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(File templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getClassDirectory() {
        return this.classDirectory;
    }

    public void setClassDirectory(File classDirectory) {
        this.classDirectory = classDirectory;
    }

    public RockerOptions getOptions() {
        return this.options;
    }

    public void setOptions(RockerOptions options) {
        this.options = options;
    }
}

