/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.antlr4.RockerLexer;
import com.fizzed.rocker.antlr4.RockerParser;
import com.fizzed.rocker.antlr4.RockerParserBaseListener;
import com.fizzed.rocker.compiler.DescriptiveErrorListener;
import com.fizzed.rocker.compiler.ParserRuntimeException;
import com.fizzed.rocker.compiler.RockerConfiguration;
import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.model.Argument;
import com.fizzed.rocker.model.BreakStatement;
import com.fizzed.rocker.model.Comment;
import com.fizzed.rocker.model.ContentClosureBegin;
import com.fizzed.rocker.model.ContentClosureEnd;
import com.fizzed.rocker.model.ContinueStatement;
import com.fizzed.rocker.model.EvalExpression;
import com.fizzed.rocker.model.ForBlockBegin;
import com.fizzed.rocker.model.ForBlockEnd;
import com.fizzed.rocker.model.ForStatement;
import com.fizzed.rocker.model.IfBlockBegin;
import com.fizzed.rocker.model.IfBlockElse;
import com.fizzed.rocker.model.IfBlockElseIf;
import com.fizzed.rocker.model.IfBlockEnd;
import com.fizzed.rocker.model.JavaImport;
import com.fizzed.rocker.model.JavaVariable;
import com.fizzed.rocker.model.NullTernaryExpression;
import com.fizzed.rocker.model.Option;
import com.fizzed.rocker.model.PlainText;
import com.fizzed.rocker.model.SourcePosition;
import com.fizzed.rocker.model.SourceRef;
import com.fizzed.rocker.model.SwitchBlock;
import com.fizzed.rocker.model.SwitchBlockEnd;
import com.fizzed.rocker.model.SwitchCaseBlock;
import com.fizzed.rocker.model.SwitchCaseBlockEnd;
import com.fizzed.rocker.model.SwitchCaseExpressionBlock;
import com.fizzed.rocker.model.SwitchCaseExpressionBlockEnd;
import com.fizzed.rocker.model.SwitchDefaultBlock;
import com.fizzed.rocker.model.SwitchDefaultBlockEnd;
import com.fizzed.rocker.model.SwitchDefaultExpressionBlock;
import com.fizzed.rocker.model.SwitchDefaultExpressionBlockEnd;
import com.fizzed.rocker.model.SwitchExpressionBlock;
import com.fizzed.rocker.model.SwitchExpressionBlockEnd;
import com.fizzed.rocker.model.TemplateModel;
import com.fizzed.rocker.model.TemplateUnit;
import com.fizzed.rocker.model.ValueClosureBegin;
import com.fizzed.rocker.model.ValueClosureEnd;
import com.fizzed.rocker.model.ValueExpression;
import com.fizzed.rocker.model.WithBlockBegin;
import com.fizzed.rocker.model.WithBlockElse;
import com.fizzed.rocker.model.WithBlockEnd;
import com.fizzed.rocker.model.WithStatement;
import com.fizzed.rocker.runtime.ParserException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateParser {
    private static final Logger log = LoggerFactory.getLogger(TemplateParser.class);
    private final RockerConfiguration configuration;

    public TemplateParser(RockerConfiguration configuration) {
        this.configuration = configuration;
    }

    public RockerConfiguration getConfiguration() {
        return this.configuration;
    }

    static TemplateIdentity parseIdentity(File baseDirectory, File templateFile) throws IOException {
        TemplateIdentity identity = new TemplateIdentity();
        identity.templateFile = templateFile;
        identity.packageName = RockerUtil.pathToPackageName(templateFile.toPath());
        Path p = templateFile.getAbsoluteFile().toPath().normalize();
        if (baseDirectory != null) {
            Path bdp = baseDirectory.getAbsoluteFile().toPath().normalize();
            if (!RockerUtil.isRelativePath(bdp, p)) {
                throw new IOException("Template file [" + templateFile + "] not relative to base dir [" + baseDirectory + "]");
            }
            Path relativePath = bdp.relativize(p);
            identity.packageName = RockerUtil.pathToPackageName(relativePath.getParent());
        }
        identity.templateName = templateFile.getName();
        identity.name = RockerUtil.templateNameToName(identity.templateName);
        identity.contentType = RockerUtil.templateNameToContentType(identity.templateName);
        return identity;
    }

    public TemplateModel parse(File f) throws IOException, ParserException {
        if (!f.exists() || !f.canRead()) {
            throw new IOException("File cannot read or does not exist [" + f + "]");
        }
        TemplateIdentity identity = TemplateParser.parseIdentity(this.configuration.getTemplateDirectory(), f);
        ANTLRFileStream input = new ANTLRFileStream(f.getPath(), "UTF-8");
        return this.parse((ANTLRInputStream)input, identity.packageName, identity.templateName, f.lastModified());
    }

    public TemplateModel parse(File f, String packageName) throws IOException, ParserException {
        ANTLRFileStream input = new ANTLRFileStream(f.getPath(), "UTF-8");
        return this.parse((ANTLRInputStream)input, packageName, f.getName(), f.lastModified());
    }

    public TemplateModel parse(String source, String qualifiedName) throws IOException, ParserException {
        ANTLRInputStream input = new ANTLRInputStream(source);
        input.name = qualifiedName;
        return this.parse(input, "views", qualifiedName, -1L);
    }

    public static ParserException buildParserException(SourceRef sourceRef, String templatePath, String msg) {
        return new ParserException(sourceRef.getBegin().getLineNumber(), sourceRef.getBegin().getPosInLine(), templatePath, msg, null);
    }

    public static ParserException buildParserException(SourceRef sourceRef, String templatePath, String msg, Throwable cause) {
        return new ParserException(sourceRef.getBegin().getLineNumber(), sourceRef.getBegin().getPosInLine(), templatePath, msg, cause);
    }

    private TemplateModel parse(ANTLRInputStream input, String packageName, String templateName, long modifiedAt) throws ParserException {
        String templatePath = packageName.replace(".", File.separator) + "/" + templateName;
        log.trace("Lexer for input stream");
        RockerLexer lexer = new RockerLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new DescriptiveErrorListener());
        CommonTokenStream tokens = null;
        try {
            log.trace("Tokenizing lexer");
            tokens = new CommonTokenStream((TokenSource)lexer);
        }
        catch (ParserRuntimeException e) {
            throw TemplateParser.unwrapParserRuntimeException(templatePath, e);
        }
        if (log.isTraceEnabled()) {
            tokens.fill();
            for (Token token : tokens.getTokens()) {
                String tokenName = null;
                Integer type = token.getType();
                for (Map.Entry values : lexer.getTokenTypeMap().entrySet()) {
                    if (!Objects.equals(values.getValue(), type)) continue;
                    tokenName = (String)values.getKey();
                }
                log.trace("{}: {}", tokenName, (Object)token);
            }
        }
        try {
            log.trace("Parsing tokens");
            RockerParser parser = new RockerParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new DescriptiveErrorListener());
            TemplateModel model = new TemplateModel(packageName, templateName, modifiedAt, this.configuration.getOptions().copy());
            TemplateParserListener listener = new TemplateParserListener(input, model, templatePath);
            ParseTreeWalker walker = new ParseTreeWalker();
            log.trace("Walking parse tree");
            walker.walk((ParseTreeListener)listener, (ParseTree)parser.template());
            if (model.getOptions().getCombineAdjacentPlain().booleanValue()) {
                this.combineAdjacentPlain(model);
            }
            if (model.getOptions().getDiscardLogicWhitespaceForContentType(model.getContentType())) {
                this.discardLogicWhitespace(model);
            }
            return model;
        }
        catch (ParserRuntimeException e) {
            throw TemplateParser.unwrapParserRuntimeException(templatePath, e);
        }
    }

    public static ParserException unwrapParserRuntimeException(String templatePath, ParserRuntimeException e) {
        return new ParserException(e.getLine(), e.getPosInLine(), templatePath, e.getMessage(), e.getCause());
    }

    public void combineAdjacentPlain(TemplateModel model) throws ParserRuntimeException {
        PlainText lastPlainText = null;
        int i = 0;
        while (i < model.getUnits().size()) {
            TemplateUnit unit = model.getUnits().get(i);
            if (unit instanceof PlainText) {
                PlainText plainText = (PlainText)unit;
                if (lastPlainText != null) {
                    try {
                        log.trace("Combining plainText @ {} with {}", (Object)lastPlainText.getSourceRef(), (Object)plainText.getSourceRef());
                        lastPlainText = lastPlainText.combineAdjacent(plainText);
                    }
                    catch (TokenException e) {
                        throw new ParserRuntimeException(plainText.getSourceRef(), e.getMessage(), e);
                    }
                    model.getUnits().set(i - 1, lastPlainText);
                    model.getUnits().remove(i);
                    continue;
                }
                lastPlainText = plainText;
            } else {
                lastPlainText = null;
            }
            ++i;
        }
    }

    public void discardLogicWhitespace(TemplateModel model) {
        PlainText plain;
        TemplateUnit unit;
        int i;
        boolean withinContentClosure = false;
        for (i = 0; i < model.getUnits().size(); ++i) {
            unit = model.getUnits().get(i);
            if (unit instanceof ContentClosureBegin) {
                withinContentClosure = true;
            } else if (unit instanceof ContentClosureEnd) {
                withinContentClosure = false;
            }
            if (withinContentClosure || unit.isBlockLevel()) continue;
            if (!(unit instanceof PlainText)) break;
            plain = (PlainText)unit;
            if (plain.isWhitespace()) {
                plain.trim();
                continue;
            }
            while (plain.chompLeadingWhitespaceToEndOfLine() > 0) {
            }
            break;
        }
        for (i = 1; i < model.getUnits().size(); ++i) {
            TemplateUnit nextUnit;
            unit = model.getUnits().get(i);
            if (!unit.isBlockLevel()) continue;
            int prevUnitTrailingWhitespaceLengthToStartOfLine = -1;
            PlainText prevPlain = null;
            TemplateUnit prevUnit = model.getUnits().get(i - 1);
            if (prevUnit instanceof PlainText) {
                prevPlain = (PlainText)prevUnit;
                prevUnitTrailingWhitespaceLengthToStartOfLine = prevPlain.trailingWhitespaceLengthToStartOfLine();
            }
            boolean lastUnit = i + 1 == model.getUnits().size();
            int nextUnitLeadingWhitespaceLengthToEndOfLine = -1;
            PlainText nextPlain = null;
            if (!lastUnit && (nextUnit = model.getUnits().get(i + 1)) instanceof PlainText) {
                nextPlain = (PlainText)nextUnit;
                nextUnitLeadingWhitespaceLengthToEndOfLine = nextPlain.leadingWhitespaceLengthToEndOfLine();
            }
            if (prevPlain == null || prevUnitTrailingWhitespaceLengthToStartOfLine < 0 || !lastUnit && (nextPlain == null || nextUnitLeadingWhitespaceLengthToEndOfLine < 0)) continue;
            prevPlain.chompTrailingLength(prevUnitTrailingWhitespaceLengthToStartOfLine);
            if (nextPlain == null || nextUnitLeadingWhitespaceLengthToEndOfLine <= 0) continue;
            nextPlain.chompLeadingLength(nextUnitLeadingWhitespaceLengthToEndOfLine);
        }
        i = 0;
        while (i < model.getUnits().size()) {
            unit = model.getUnits().get(i);
            if (unit instanceof PlainText && (plain = (PlainText)unit).getText().isEmpty()) {
                model.getUnits().remove(i);
                continue;
            }
            ++i;
        }
    }

    public static class TemplateParserListener
    extends RockerParserBaseListener {
        private final ANTLRInputStream input;
        private final TemplateModel model;
        private final String templatePath;
        private final Stack<WithStatement> withStatements = new Stack();

        public TemplateParserListener(ANTLRInputStream input, TemplateModel model, String templatePath) {
            this.input = input;
            this.model = model;
            this.templatePath = templatePath;
        }

        public SourceRef createSourceRef(ParserRuleContext rule) {
            return this.createSourceRef(rule, rule.getStart(), rule.getStop());
        }

        public SourceRef createSourceRef(ParserRuleContext rule, Token start, Token stop) {
            SourcePosition begin = new SourcePosition(start.getLine(), start.getCharPositionInLine() + 1, start.getStartIndex());
            int stopIndex = stop.getStopIndex() + 1;
            int length = stopIndex - start.getStartIndex();
            String text = this.input.getText(new Interval(begin.getPosInFile(), stop.getStopIndex()));
            return new SourceRef(begin, length, text);
        }

        @Override
        public void enterEveryRule(ParserRuleContext ctx) {
            if (log.isTraceEnabled()) {
                log.trace("{} entered with {}", (Object)ctx.getClass().getName(), (Object)ctx.toStringTree());
            }
        }

        @Override
        public void exitEveryRule(ParserRuleContext ctx) {
            if (log.isTraceEnabled()) {
                log.trace("{} exited with {}", (Object)ctx.getClass().getName(), (Object)ctx.toStringTree());
            }
        }

        public void verifyTemplateHeaderElementOK() {
            for (TemplateUnit unit : this.model.getUnits()) {
                PlainText plain;
                if (unit instanceof Comment || !(unit instanceof PlainText) || (plain = (PlainText)unit).isWhitespace()) continue;
                SourcePosition pos = plain.findSourcePositionOfNonWhitespace();
                throw new ParserRuntimeException(pos.getLineNumber(), pos.getPosInLine(), "plain text not allowed before end of template header");
            }
            List<TemplateUnit> units = this.model.getUnits();
            int i = 0;
            while (i < units.size()) {
                TemplateUnit unit = units.get(i);
                if (unit instanceof PlainText) {
                    log.trace("Discarding whitespace-only plain text in template header");
                    units.remove(i);
                    continue;
                }
                ++i;
            }
        }

        public boolean areWeCurrentlyInAForLoop() {
            int depth = 0;
            for (int i = this.model.getUnits().size() - 1; i >= 0; --i) {
                TemplateUnit unit = this.model.getUnits().get(i);
                if (unit instanceof ForBlockBegin) {
                    if (depth == 0) {
                        return true;
                    }
                    --depth;
                    continue;
                }
                if (!(unit instanceof ForBlockEnd)) continue;
                ++depth;
            }
            return false;
        }

        public boolean areWeCurrentlyInASwitchBlock() {
            int depth = 0;
            for (int i = this.model.getUnits().size() - 1; i >= 0; --i) {
                TemplateUnit unit = this.model.getUnits().get(i);
                if (unit instanceof SwitchBlock) {
                    if (depth == 0) {
                        return true;
                    }
                    --depth;
                    continue;
                }
                if (!(unit instanceof SwitchBlockEnd)) continue;
                ++depth;
            }
            return false;
        }

        public boolean areWeCurrentlyInACase() {
            int depth = 0;
            for (int i = this.model.getUnits().size() - 1; i >= 0; --i) {
                TemplateUnit unit = this.model.getUnits().get(i);
                if (unit instanceof SwitchCaseBlock) {
                    if (depth == 0) {
                        return true;
                    }
                    --depth;
                    continue;
                }
                if (!(unit instanceof SwitchCaseBlockEnd)) continue;
                ++depth;
            }
            return false;
        }

        public boolean areWeCurrentlyInADefault() {
            int depth = 0;
            for (int i = this.model.getUnits().size() - 1; i >= 0; --i) {
                TemplateUnit unit = this.model.getUnits().get(i);
                if (unit instanceof SwitchDefaultBlock) {
                    if (depth == 0) {
                        return true;
                    }
                    --depth;
                    continue;
                }
                if (!(unit instanceof SwitchDefaultBlockEnd)) continue;
                ++depth;
            }
            return false;
        }

        @Override
        public void enterComment(RockerParser.CommentContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.getText();
            String trimmedComment = text.substring(2, text.length() - 2);
            this.model.getUnits().add(new Comment(sourceRef, trimmedComment));
        }

        @Override
        public void enterImportDeclaration(RockerParser.ImportDeclarationContext ctx) {
            this.verifyTemplateHeaderElementOK();
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.ImportStatementContext statementCtx = ctx.importStatement();
            String statement = statementCtx.getText().substring(6).trim();
            this.model.getImports().add(new JavaImport(sourceRef, statement));
        }

        @Override
        public void enterOptionDeclaration(RockerParser.OptionDeclarationContext ctx) {
            this.verifyTemplateHeaderElementOK();
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.OptionStatementContext statementCtx = ctx.optionStatement();
            String statement = statementCtx.getText().substring(6).trim();
            this.model.getOptions().parseOption(new Option(sourceRef, statement));
        }

        @Override
        public void exitArgumentsDeclaration(RockerParser.ArgumentsDeclarationContext ctx) {
        }

        @Override
        public void enterArgumentsStatement(RockerParser.ArgumentsStatementContext ctx) {
            this.verifyTemplateHeaderElementOK();
            SourceRef sourceRef = this.createSourceRef(ctx);
            String statement = ctx.getText().substring(4).trim();
            if (!statement.startsWith("(") || !statement.endsWith(")")) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "Arguments for @args must be enclosed with parentheses");
            }
            statement = statement.substring(1, statement.length() - 1);
            statement = statement.replaceAll("\\s+", " ").trim();
            try {
                List<JavaVariable> args = JavaVariable.parseList(statement);
                for (JavaVariable arg : args) {
                    if (arg.getType() == null) {
                        throw new TokenException("Argument " + arg.getName() + " missing type");
                    }
                    this.model.getArguments().add(new Argument(sourceRef, arg));
                }
            }
            catch (TokenException e) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, e.getMessage(), e);
            }
            for (int i = 0; i < this.model.getArguments().size(); ++i) {
                Argument arg = this.model.getArguments().get(i);
                if (!arg.getType().equals("RockerBody") || i == this.model.getArguments().size() - 1) continue;
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "RockerBody type only allowed as last argument");
            }
        }

        @Override
        public void enterPlain(RockerParser.PlainContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            if (ctx.plainBlock() != null) {
                log.trace("Plain but within context of PlainBlock -- skipping it!");
                return;
            }
            String text = ctx.getText();
            String unescaped = PlainText.unescape(text);
            this.model.getUnits().add(new PlainText(sourceRef, unescaped));
        }

        @Override
        public void enterPlainBlock(RockerParser.PlainBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = null;
            if (ctx.LCURLY() == null) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "Did not find LCURLY");
            }
            text = ctx.LCURLY().getText();
            this.model.getUnits().add(new PlainText(sourceRef, text));
        }

        @Override
        public void exitPlainBlock(RockerParser.PlainBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            if (ctx.RCURLY() == null) {
                return;
            }
            String text = ctx.RCURLY().getText();
            this.model.getUnits().add(new PlainText(sourceRef, text));
        }

        @Override
        public void enterPlainElseIfBlock(RockerParser.PlainElseIfBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new PlainText(sourceRef, ctx.ELSE_IF().getText()));
        }

        @Override
        public void enterPlainElseBlock(RockerParser.PlainElseBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            if (ctx.ELSE() == null) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "Did not find ELSE");
            }
            String text = ctx.ELSE().getText();
            this.model.getUnits().add(new PlainText(sourceRef, text));
        }

        @Override
        public void exitPlainElseBlock(RockerParser.PlainElseBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            if (ctx.RCURLY() == null) {
                return;
            }
            String text = ctx.RCURLY().getText();
            this.model.getUnits().add(new PlainText(sourceRef, text));
        }

        @Override
        public void enterValueClosure(RockerParser.ValueClosureContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.ValueClosureExpressionContext expressionCtx = ctx.valueClosureExpression();
            String expr = expressionCtx.getText();
            expr = RockerUtil.chompClosureOpen(expr);
            this.model.getUnits().add(new ValueClosureBegin(sourceRef, expr));
        }

        @Override
        public void exitValueClosure(RockerParser.ValueClosureContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new ValueClosureEnd(sourceRef));
        }

        @Override
        public void enterContentClosure(RockerParser.ContentClosureContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.ContentClosureExpressionContext expressionCtx = ctx.contentClosureExpression();
            String expr = expressionCtx.getText();
            String identifier = RockerUtil.chompClosureAssignmentOpen(expr);
            this.model.getUnits().add(new ContentClosureBegin(sourceRef, identifier));
        }

        @Override
        public void exitContentClosure(RockerParser.ContentClosureContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new ContentClosureEnd(sourceRef));
        }

        @Override
        public void enterValue(RockerParser.ValueContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.ValueExpressionContext expressionCtx = ctx.valueExpression();
            String expr = expressionCtx.getText();
            if (expr.equals("break")) {
                if (!this.areWeCurrentlyInAForLoop() && !this.areWeCurrentlyInASwitchBlock()) {
                    throw new ParserRuntimeException(sourceRef, "@break used outside @for loop OR @switch block", null);
                }
                this.model.getUnits().add(new BreakStatement(sourceRef));
            } else if (expr.equals("continue")) {
                if (!this.areWeCurrentlyInAForLoop()) {
                    throw new ParserRuntimeException(sourceRef, "@continue used outside @for loop", null);
                }
                this.model.getUnits().add(new ContinueStatement(sourceRef));
            } else {
                boolean nullSafety = false;
                if (expr.startsWith("?")) {
                    nullSafety = true;
                    expr = expr.substring(1);
                }
                this.model.getUnits().add(new ValueExpression(sourceRef, expr, nullSafety));
            }
        }

        @Override
        public void enterNullTernary(RockerParser.NullTernaryContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.NullTernaryExpressionContext nullTernaryExpr = ctx.nullTernaryExpression();
            String leftExpr = nullTernaryExpr.MV_NULL_TERNARY_LH().getText();
            leftExpr = leftExpr.substring(0, leftExpr.length() - 2);
            String rightExpr = nullTernaryExpr.MV_NULL_TERNARY_RH().getText();
            this.model.getUnits().add(new NullTernaryExpression(sourceRef, leftExpr, rightExpr));
        }

        @Override
        public void enterEval(RockerParser.EvalContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            RockerParser.EvalExpressionContext evalExpr = ctx.evalExpression();
            String expr = evalExpr.getText();
            this.model.getUnits().add(new EvalExpression(sourceRef, expr, false));
        }

        @Override
        public void enterForBlock(RockerParser.ForBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String expr = ctx.MV_FOR().getText();
            expr = expr.substring(3, expr.length() - 1).trim();
            try {
                ForStatement statement = ForStatement.parse(expr);
                if (!RockerUtil.isJava8Plus(this.model) && statement.hasAnyUntypedArguments()) {
                    throw new TokenException("Untyped variables cannot be used with Java " + this.model.getOptions().getJavaVersion().getLabel() + " (only allowed with Java 1.8+)");
                }
                this.model.getUnits().add(new ForBlockBegin(sourceRef, expr, statement));
            }
            catch (TokenException e) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, e.getMessage(), e);
            }
        }

        @Override
        public void exitForBlock(RockerParser.ForBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new ForBlockEnd(sourceRef));
        }

        @Override
        public void enterWithBlock(RockerParser.WithBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String expr = ctx.MV_WITH().getText();
            expr = expr.substring(4, expr.length() - 1).trim();
            try {
                WithStatement statement = WithStatement.parse(expr, this.templatePath);
                if (!RockerUtil.isJava8Plus(this.model) && statement.hasAnyVariableNullType()) {
                    throw new TokenException("Untyped variables cannot be used with Java " + this.model.getOptions().getJavaVersion().getLabel() + " (only allowed with Java 1.8+)");
                }
                this.model.getUnits().add(new WithBlockBegin(sourceRef, expr, statement));
                this.withStatements.push(statement);
            }
            catch (TokenException e) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, e.getMessage(), e);
            }
        }

        @Override
        public void enterWithElseBlock(RockerParser.WithElseBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new WithBlockElse(sourceRef));
            WithStatement withStatement = this.withStatements.peek();
            if (withStatement.getVariables().size() > 1) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "Cannot have an else statement for a @with block with multiple arguments");
            }
            if (!withStatement.isNullSafe()) {
                throw TemplateParser.buildParserException(sourceRef, this.templatePath, "Cannot have an else statement for a @with block that is not null-safe");
            }
        }

        @Override
        public void exitWithBlock(RockerParser.WithBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new WithBlockEnd(sourceRef));
            this.withStatements.pop();
        }

        @Override
        public void enterIfBlock(RockerParser.IfBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String expr = ctx.MV_IF().getText();
            expr = expr.substring(2, expr.length() - 1).trim();
            this.model.getUnits().add(new IfBlockBegin(sourceRef, expr));
        }

        @Override
        public void exitIfBlock(RockerParser.IfBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new IfBlockEnd(sourceRef));
        }

        @Override
        public void enterIfElseIfBlock(RockerParser.IfElseIfBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.ELSE_IF().getText();
            int idxFirst = text.indexOf(40);
            int idxLast = text.lastIndexOf(41);
            String expression = text.substring(idxFirst, idxLast + 1);
            this.model.getUnits().add(new IfBlockElseIf(sourceRef, expression));
        }

        @Override
        public void enterIfElseBlock(RockerParser.IfElseBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new IfBlockElse(sourceRef));
        }

        @Override
        public void enterSwitchBlock(RockerParser.SwitchBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.MV_SWITCH().getText();
            int idxFirst = text.indexOf(40);
            int idxLast = text.lastIndexOf(41);
            String expression = text.substring(idxFirst, idxLast + 1);
            this.model.getUnits().add(new SwitchBlock(sourceRef, expression));
        }

        @Override
        public void exitSwitchBlock(RockerParser.SwitchBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchBlockEnd(sourceRef));
            this.verifySwitchBlock();
        }

        @Override
        public void enterSwitchExpressionBlock(RockerParser.SwitchExpressionBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.MV_SWITCH().getText();
            int idxFirst = text.indexOf(40);
            int idxLast = text.lastIndexOf(41);
            String expression = text.substring(idxFirst, idxLast + 1);
            this.model.getUnits().add(new SwitchExpressionBlock(sourceRef, expression));
        }

        @Override
        public void exitSwitchExpressionBlock(RockerParser.SwitchExpressionBlockContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchExpressionBlockEnd(sourceRef));
            this.verifySwitchExpressionBlock();
        }

        @Override
        public void enterSwitchExpressionCase(RockerParser.SwitchExpressionCaseContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.CASE_EXPRESSION().getText();
            int idxFirst = text.indexOf(40);
            int idxLast = text.lastIndexOf(41);
            String expression = text.substring(idxFirst + 1, idxLast);
            this.model.getUnits().add(new SwitchCaseExpressionBlock(sourceRef, expression));
        }

        @Override
        public void exitSwitchExpressionCase(RockerParser.SwitchExpressionCaseContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchCaseExpressionBlockEnd(sourceRef));
        }

        @Override
        public void enterSwitchExpressionDefault(RockerParser.SwitchExpressionDefaultContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchDefaultExpressionBlock(sourceRef));
        }

        @Override
        public void exitSwitchExpressionDefault(RockerParser.SwitchExpressionDefaultContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchDefaultExpressionBlockEnd(sourceRef));
        }

        private void verifySwitchBlock() {
            List<TemplateUnit> units = this.model.getUnits();
            ArrayList<TemplateUnit> toRemove = new ArrayList<TemplateUnit>();
            int unitsSize = units.size();
            for (int i = 0; i < unitsSize; ++i) {
                TemplateUnit unit = units.get(i);
                if (!(unit instanceof PlainText)) continue;
                PlainText plain = (PlainText)unit;
                if (!this.inSwitchButNotCaseOrDefault(i)) continue;
                if (plain.isWhitespace()) {
                    toRemove.add(unit);
                    continue;
                }
                SourcePosition pos = plain.findSourcePositionOfNonWhitespace();
                throw new ParserRuntimeException(pos.getLineNumber(), pos.getPosInLine(), "plain text not allowed before end of switch block");
            }
            units.removeAll(toRemove);
        }

        private void verifySwitchExpressionBlock() {
            List<TemplateUnit> units = this.model.getUnits();
            ArrayList<TemplateUnit> toRemove = new ArrayList<TemplateUnit>();
            int unitsSize = units.size();
            for (int i = 0; i < unitsSize; ++i) {
                TemplateUnit unit = units.get(i);
                if (!(unit instanceof PlainText)) continue;
                PlainText plain = (PlainText)unit;
                if (!this.inSwitchExpressionButNotCaseOrDefault(i)) continue;
                if (plain.isWhitespace()) {
                    toRemove.add(unit);
                    continue;
                }
                SourcePosition pos = plain.findSourcePositionOfNonWhitespace();
                throw new ParserRuntimeException(pos.getLineNumber(), pos.getPosInLine(), "plain text not allowed before end of switch block");
            }
            units.removeAll(toRemove);
        }

        private boolean inSwitchButNotCaseOrDefault(int i) {
            for (int j = i; j >= 0; --j) {
                TemplateUnit templateUnit = this.model.getUnits().get(j);
                if (templateUnit instanceof SwitchCaseBlockEnd || templateUnit instanceof SwitchDefaultBlockEnd || templateUnit instanceof SwitchBlock) {
                    return true;
                }
                if (!(templateUnit instanceof SwitchCaseBlock) && !(templateUnit instanceof SwitchDefaultBlock) && !(templateUnit instanceof SwitchBlockEnd)) continue;
                return false;
            }
            return false;
        }

        private boolean inSwitchExpressionButNotCaseOrDefault(int i) {
            for (int j = i; j >= 0; --j) {
                TemplateUnit templateUnit = this.model.getUnits().get(j);
                if (templateUnit instanceof SwitchCaseExpressionBlockEnd || templateUnit instanceof SwitchDefaultExpressionBlockEnd || templateUnit instanceof SwitchExpressionBlock) {
                    return true;
                }
                if (!(templateUnit instanceof SwitchCaseExpressionBlock) && !(templateUnit instanceof SwitchDefaultExpressionBlock) && !(templateUnit instanceof SwitchExpressionBlockEnd)) continue;
                return false;
            }
            return false;
        }

        @Override
        public void enterSwitchCase(RockerParser.SwitchCaseContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            String text = ctx.CASE().getText();
            int idxFirst = text.indexOf(40);
            int idxLast = text.lastIndexOf(41);
            String expression = text.substring(idxFirst + 1, idxLast);
            this.model.getUnits().add(new SwitchCaseBlock(sourceRef, expression));
        }

        @Override
        public void exitSwitchCase(RockerParser.SwitchCaseContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchCaseBlockEnd(sourceRef));
        }

        @Override
        public void enterSwitchDefault(RockerParser.SwitchDefaultContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchDefaultBlock(sourceRef));
        }

        @Override
        public void exitSwitchDefault(RockerParser.SwitchDefaultContext ctx) {
            SourceRef sourceRef = this.createSourceRef(ctx);
            this.model.getUnits().add(new SwitchDefaultBlockEnd(sourceRef));
        }
    }

    static class TemplateIdentity {
        public File templateFile;
        public String packageName;
        public String templateName;
        public String name;
        public ContentType contentType;

        TemplateIdentity() {
        }
    }
}

