/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.model.JavaVariable;
import java.util.ArrayList;
import java.util.List;

public class ForStatement {
    private final Form form;
    private final List<String> generalParts;
    private final List<JavaVariable> arguments;
    private final String valueExpression;

    public ForStatement(List<String> generalParts) {
        this.form = Form.GENERAL;
        this.generalParts = generalParts;
        this.arguments = null;
        this.valueExpression = null;
    }

    public ForStatement(List<JavaVariable> arguments, String valueExpression) {
        this.form = Form.ENHANCED;
        this.generalParts = null;
        this.arguments = arguments;
        this.valueExpression = valueExpression;
    }

    public Form getForm() {
        return this.form;
    }

    public List<String> getGeneralParts() {
        return this.generalParts;
    }

    public List<JavaVariable> getArguments() {
        return this.arguments;
    }

    public boolean hasAnyUntypedArguments() {
        if (this.arguments != null) {
            for (JavaVariable jv : this.arguments) {
                if (jv.getType() != null) continue;
                return true;
            }
        }
        return false;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public static ForStatement parse(String statement) throws TokenException {
        if (!statement.startsWith("(")) {
            throw new TokenException("For block does not start with parenthese");
        }
        if (!statement.endsWith(")")) {
            throw new TokenException("For block does not end with parenthese");
        }
        if ((statement = statement.substring(1, statement.length() - 1)).contains(";")) {
            String[] generalParts = statement.split(";");
            if (generalParts.length != 3) {
                throw new TokenException("For block has invalid general form [e.g. for (initialization; termination; increment) {]");
            }
            ArrayList<String> parts = new ArrayList<String>();
            for (String s : generalParts) {
                parts.add(s.trim());
            }
            return new ForStatement(parts);
        }
        if (statement.contains(":")) {
            String[] enhancedParts = statement.split(":");
            if (enhancedParts.length != 2) {
                throw new TokenException("For block has invalid enhanced form [e.g. for (item : items) {]");
            }
            String argsPart = enhancedParts[0].trim();
            if (argsPart.equals("")) {
                throw new TokenException("For block with enhanced form contains an empty string for arguments part (e.g. for (arg : list)");
            }
            boolean hasParenthese = false;
            if (argsPart.startsWith("(")) {
                if (!argsPart.endsWith(")")) {
                    throw new TokenException("For block with enhanced form contains invalid arguments section (closing parenthese not found)");
                }
                hasParenthese = true;
                argsPart = argsPart.substring(1, argsPart.length() - 1);
            }
            List<JavaVariable> arguments = null;
            try {
                arguments = JavaVariable.parseList(argsPart);
            }
            catch (TokenException e) {
                throw new TokenException(e.getMessage());
            }
            if (arguments.size() > 1 && !hasParenthese) {
                throw new TokenException("For block with enhanced form contains invalid arguments section (more than 1 argument must be enclosed with parenthese e.g. (k,v))");
            }
            if (arguments.size() > 3) {
                throw new TokenException("For block with enhanced form contains " + arguments.size() + " arguments (at most 3 supported)");
            }
            String valuePart = enhancedParts[1].trim();
            if (valuePart.equals("")) {
                throw new TokenException("For block with enhanced form contains an empty string for value part (e.g. for (item : value)");
            }
            return new ForStatement(arguments, valuePart.trim());
        }
        throw new TokenException("For block appears to be invalid (neither general or enhanced form detected)");
    }

    public static enum Form {
        GENERAL,
        ENHANCED;

    }
}

