/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.model.SourcePosition;
import com.fizzed.rocker.model.SourceRef;
import com.fizzed.rocker.model.TemplateUnit;

public class PlainText
extends TemplateUnit {
    private String text;

    public PlainText(SourceRef sourceRef, String text) {
        super(sourceRef);
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public PlainText combineAdjacent(PlainText other) throws TokenException {
        SourceRef combinedSourceRef = this.getSourceRef().combineAdjacent(other.getSourceRef());
        return new PlainText(combinedSourceRef, this.text + other.text);
    }

    public boolean isWhitespace() {
        return RockerUtil.isWhitespace(this.text);
    }

    public void trim() {
        this.text = this.text.trim();
    }

    public int trailingWhitespaceLengthToStartOfLine() {
        int length = 0;
        for (int i = this.text.length() - 1; i >= 0; --i) {
            char c = this.text.charAt(i);
            if (RockerUtil.isWhitespaceNoLineBreak(c)) {
                ++length;
                continue;
            }
            if (c == '\n') break;
            return -1;
        }
        return length;
    }

    public int leadingWhitespaceLengthToEndOfLine() {
        int length = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (RockerUtil.isWhitespaceNoLineBreak(c)) {
                ++length;
                continue;
            }
            if (c == '\n') {
                ++length;
                break;
            }
            return -1;
        }
        return length;
    }

    public int chompTrailingWhitespaceToStartOfLine() {
        int length = this.trailingWhitespaceLengthToStartOfLine();
        this.chompTrailingLength(length);
        return length;
    }

    public void chompTrailingLength(int length) {
        if (length > 0 && length <= this.text.length()) {
            this.text = this.text.substring(0, this.text.length() - length);
        }
    }

    public int chompLeadingWhitespaceToEndOfLine() {
        int length = this.leadingWhitespaceLengthToEndOfLine();
        this.chompLeadingLength(length);
        return length;
    }

    public void chompLeadingLength(int length) {
        if (length > 0 && length <= this.text.length()) {
            this.text = this.text.substring(length);
        }
    }

    public SourcePosition findSourcePositionOfNonWhitespace() {
        int lineNumber = this.getSourceRef().getBegin().getLineNumber();
        int posInLine = this.getSourceRef().getBegin().getPosInLine();
        int posInFile = this.getSourceRef().getBegin().getPosInFile();
        String sourceText = this.getSourceRef().getText();
        for (int i = 0; i < sourceText.length(); ++i) {
            char c = sourceText.charAt(i);
            if (!RockerUtil.isWhitespace(c)) {
                return new SourcePosition(lineNumber, posInLine, posInFile);
            }
            if (c == '\n') {
                ++lineNumber;
                posInLine = -1;
            }
            ++posInFile;
            ++posInLine;
        }
        return this.getSourceRef().getBegin();
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == '@' && i + 1 < s.length()) {
                c2 = s.charAt(i + 1);
                if (c2 == '@') {
                    sb.append("@");
                    ++i;
                    continue;
                }
                if (c2 == '}') {
                    sb.append("}");
                    ++i;
                    continue;
                }
                if (c2 == '{') {
                    sb.append("{");
                    ++i;
                    continue;
                }
            } else if (c1 == '\r' && i + 1 < s.length() && (c2 = s.charAt(i + 1)) == '\n') {
                sb.append("\n");
                ++i;
                continue;
            }
            sb.append(c1);
        }
        return sb.toString();
    }
}

