/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.processor;

import com.fizzed.rocker.model.PlainText;
import com.fizzed.rocker.model.PostProcessorException;
import com.fizzed.rocker.model.TemplateModel;
import com.fizzed.rocker.model.TemplateModelPostProcessor;
import com.fizzed.rocker.model.TemplateUnit;

public class WhitespaceRemovalProcessor
implements TemplateModelPostProcessor {
    private static final String LINE_END = "[ \t]+[\n\r]+";
    private static final String IN_LINE = "[ \t]{2,}";
    private static final String LINE_START = "[\n\r]+[ \t]+";

    @Override
    public TemplateModel process(TemplateModel templateModel, int ppIndex) throws PostProcessorException {
        for (int i = 0; i < templateModel.getUnits().size(); ++i) {
            TemplateUnit tu = templateModel.getUnits().get(i);
            if (!(tu instanceof PlainText)) continue;
            PlainText pt = (PlainText)tu;
            PlainText replacementPt = new PlainText(pt.getSourceRef(), this.reduceWhitespace(pt.getText()));
            templateModel.getUnits().add(i, replacementPt);
            templateModel.getUnits().remove(i + 1);
        }
        return templateModel;
    }

    private String reduceWhitespace(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll(LINE_END, "\n").replaceAll(LINE_START, "\n").replaceAll(IN_LINE, " ");
    }
}

