/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.reload;

import com.fizzed.rocker.reload.ReloadingRockerBootstrap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RockerClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(RockerClassLoader.class);
    private final ReloadingRockerBootstrap bootstrap;

    public RockerClassLoader(ReloadingRockerBootstrap bootstrap, ClassLoader parent) {
        super(parent);
        this.bootstrap = bootstrap;
    }

    public boolean isClassLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (!this.bootstrap.isReloadableClass(className)) {
            return super.loadClass(className);
        }
        try {
            ByteArrayOutputStream buffer;
            String resourceName = className.replace(".", "/") + ".class";
            URL url = this.getResource(resourceName);
            if (url == null) {
                throw new ClassNotFoundException("Class " + className + " not found");
            }
            log.trace("loading class: " + url);
            URLConnection connection = url.openConnection();
            try (InputStream input = connection.getInputStream();){
                buffer = new ByteArrayOutputStream();
                int data = input.read();
                while (data != -1) {
                    buffer.write(data);
                    data = input.read();
                }
            }
            byte[] classData = buffer.toByteArray();
            return this.defineClass(className, classData, 0, classData.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }
}

