/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.maven;

import com.fizzed.rocker.compiler.JavaGeneratorRunnable;
import com.fizzed.rocker.model.JavaVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="rocker.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="rocker.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="rocker.skipTouch", defaultValue="false")
    protected boolean skipTouch;
    @Parameter(property="rocker.touchFile", defaultValue="${basedir}/pom.xml")
    protected String touchFile;
    @Parameter(property="rocker.addAsSources", defaultValue="true")
    protected boolean addAsSources;
    @Parameter(property="rocker.addAsTestSources", defaultValue="false")
    protected boolean addAsTestSources;
    @Parameter(property="rocker.javaVersion")
    protected String javaVersion;
    @Parameter(property="rocker.extendsClass")
    protected String extendsClass;
    @Parameter(property="rocker.extendsModelClass")
    protected String extendsModelClass;
    @Parameter(property="rocker.optimize")
    protected Boolean optimize;
    @Parameter(property="rocker.discardLogicWhitespace")
    protected Boolean discardLogicWhitespace;
    @Parameter(property="rocker.targetCharset")
    protected String targetCharset;
    @Parameter(property="rocker.suffixRegex")
    protected String suffixRegex;
    @Parameter(property="rocker.templateDirectory", defaultValue="${project.build.sourceDirectory}")
    protected File templateDirectory;
    @Parameter(property="rocker.outputDirectory", defaultValue="${project.build.directory}/generated-sources/rocker", required=true)
    protected File outputDirectory;
    @Parameter(property="rocker.classDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    protected File classDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="rocker.postProcessing", required=false)
    protected String[] postProcessing;
    @Parameter(property="rocker.markAsGenerated")
    protected Boolean markAsGenerated;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on, will skip goal.");
            return;
        }
        if (this.templateDirectory == null) {
            throw new MojoExecutionException("Property templateDirectory cannot be null/empty");
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("Property outputDirectory cannot be null/empty");
        }
        if (this.classDirectory == null) {
            throw new MojoExecutionException("Property classDirectory cannot be null/empty");
        }
        if (this.javaVersion == null || this.javaVersion.length() == 0) {
            this.javaVersion = JavaVersion.current();
            this.getLog().info((CharSequence)("Property rocker.javaVersion not set. Using your JDK version " + this.javaVersion));
        } else {
            this.getLog().info((CharSequence)("Targeting java version " + this.javaVersion));
        }
        try {
            JavaGeneratorRunnable jgr = new JavaGeneratorRunnable();
            jgr.getParser().getConfiguration().setTemplateDirectory(this.templateDirectory);
            jgr.getGenerator().getConfiguration().setOutputDirectory(this.outputDirectory);
            jgr.getGenerator().getConfiguration().setClassDirectory(this.classDirectory);
            jgr.setFailOnError(this.failOnError);
            if (this.suffixRegex != null) {
                jgr.setSuffixRegex(this.suffixRegex);
            }
            if (this.javaVersion != null) {
                jgr.getParser().getConfiguration().getOptions().setJavaVersion(this.javaVersion);
            }
            if (this.extendsClass != null) {
                jgr.getParser().getConfiguration().getOptions().setExtendsClass(this.extendsClass);
            }
            if (this.extendsModelClass != null) {
                jgr.getParser().getConfiguration().getOptions().setExtendsModelClass(this.extendsModelClass);
            }
            if (this.discardLogicWhitespace != null) {
                jgr.getParser().getConfiguration().getOptions().setDiscardLogicWhitespace(this.discardLogicWhitespace);
            }
            if (this.targetCharset != null) {
                jgr.getParser().getConfiguration().getOptions().setTargetCharset(this.targetCharset);
            }
            if (this.optimize != null) {
                jgr.getParser().getConfiguration().getOptions().setOptimize(this.optimize);
            }
            if (this.postProcessing != null) {
                jgr.getParser().getConfiguration().getOptions().setPostProcessing(this.postProcessing);
            }
            if (this.markAsGenerated != null) {
                jgr.getParser().getConfiguration().getOptions().setMarkAsGenerated(this.markAsGenerated);
            }
            jgr.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.addAsTestSources) {
            this.getLog().info((CharSequence)("Added test sources with " + this.outputDirectory));
            this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        } else if (this.addAsSources) {
            this.getLog().info((CharSequence)("Added sources with " + this.outputDirectory));
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (!this.skipTouch && this.touchFile != null && this.touchFile.length() > 0) {
            File f = new File(this.touchFile);
            this.getLog().info((CharSequence)("Touching file " + f));
            try {
                if (!f.exists()) {
                    new FileOutputStream(f).close();
                }
                f.setLastModified(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"Unable to touch file", (Throwable)e);
            }
        }
    }
}

