/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.RenderingException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class PlainTextUnloadedClassLoader {
    private final String className;
    private final Map<String, byte[]> fields;

    public PlainTextUnloadedClassLoader(String className, Map<String, byte[]> fieldNames) {
        this.className = className;
        this.fields = fieldNames;
    }

    public byte[] tryGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int size() {
        return this.fields.size();
    }

    public byte[] get(String fieldName) throws NoSuchFieldException {
        byte[] bytes = this.fields.get(fieldName);
        if (bytes == null) {
            throw new NoSuchFieldException("Class " + this.className + " does not define a String field of " + fieldName);
        }
        return bytes;
    }

    @Deprecated
    public static PlainTextUnloadedClassLoader tryLoad(String classBinaryName, String charsetName) {
        try {
            return PlainTextUnloadedClassLoader.load(classBinaryName, charsetName);
        }
        catch (Exception e) {
            throw new RenderingException(e.getMessage(), e);
        }
    }

    public static PlainTextUnloadedClassLoader tryLoad(ClassLoader sourceClassLoader, String classBinaryName, String charsetName) {
        try {
            return PlainTextUnloadedClassLoader.load(sourceClassLoader, classBinaryName, charsetName);
        }
        catch (Exception e) {
            throw new RenderingException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static PlainTextUnloadedClassLoader load(String classBinaryName, String charsetName) throws ClassNotFoundException, MalformedURLException, IllegalArgumentException, UnsupportedEncodingException, IllegalAccessException {
        return PlainTextUnloadedClassLoader.load(PlainTextUnloadedClassLoader.class.getClassLoader(), classBinaryName, charsetName);
    }

    public static PlainTextUnloadedClassLoader load(ClassLoader sourceClassLoader, String classBinaryName, String charsetName) throws ClassNotFoundException, MalformedURLException, IllegalArgumentException, UnsupportedEncodingException, IllegalAccessException {
        String resourceName = classBinaryName.replace('.', '/') + ".class";
        URL url = sourceClassLoader.getResource(resourceName);
        if (url == null) {
            throw new ClassNotFoundException("Unable to find class as resource [" + resourceName + "]");
        }
        String resourcePath = url.toString();
        int pos = resourcePath.lastIndexOf("/" + resourceName);
        if (pos < 0) {
            throw new ClassNotFoundException("Unable to compute resource base for [" + resourceName + "]");
        }
        String resourceBasePath = resourcePath.substring(0, ++pos);
        URL resourceBase = new URL(resourceBasePath);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{resourceBase}, null);
        Class<?> type = classLoader.loadClass(classBinaryName);
        HashMap<String, byte[]> fields = new HashMap<String, byte[]>();
        for (Field field : type.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            field.setAccessible(true);
            String s = (String)field.get(null);
            byte[] bytes = s.getBytes(charsetName);
            fields.put(field.getName(), bytes);
        }
        return new PlainTextUnloadedClassLoader(classBinaryName, fields);
    }
}

