/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.assembly;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyUtils {
    private static final Logger logger = LoggerFactory.getLogger(AssemblyUtils.class);

    public static void copyStandardProjectResources(File projectDir, File outputDir) throws IOException {
        FileUtils.copyDirectory((File)projectDir, (File)outputDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.startsWith("readme") || name.startsWith("changelog") || name.startsWith("release") || name.startsWith("license");
            }
        });
    }

    public static File createTGZ(File outputDir, File inputDir, String name) throws IOException {
        File tgzFile = new File(outputDir, name + ".tar.gz");
        try (TarArchiveOutputStream tgzout = AssemblyUtils.createTGZStream(tgzFile);){
            AssemblyUtils.addFileToTGZStream(tgzout, inputDir, name, false);
        }
        return tgzFile;
    }

    public static TarArchiveOutputStream createTGZStream(File tgzFile) throws IOException {
        TarArchiveOutputStream tgzout = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tgzFile))));
        tgzout.setBigNumberMode(1);
        tgzout.setLongFileMode(2);
        return tgzout;
    }

    public static void addFileToTGZStream(TarArchiveOutputStream tgzout, File f, String base, boolean appendName) throws IOException {
        String entryName = base;
        if (appendName) {
            entryName = !entryName.equals("") ? (!entryName.endsWith("/") ? entryName + "/" + f.getName() : entryName + f.getName()) : entryName + f.getName();
        }
        TarArchiveEntry tarEntry = new TarArchiveEntry(f, entryName);
        if (f.isFile() && f.canExecute()) {
            tarEntry.setMode(493);
        }
        tgzout.putArchiveEntry((ArchiveEntry)tarEntry);
        if (f.isFile()) {
            try (FileInputStream in = new FileInputStream(f);){
                IOUtils.copy((InputStream)in, (OutputStream)tgzout);
            }
            tgzout.closeArchiveEntry();
        } else {
            tgzout.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    logger.info(" adding: " + entryName + "/" + child.getName());
                    AssemblyUtils.addFileToTGZStream(tgzout, child, entryName + "/", true);
                }
            }
        }
    }
}

