/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.assembly;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFile {
    private static final Logger logger = LoggerFactory.getLogger(CopyFile.class);

    public static void main(String[] args) throws Exception {
        new CopyFile().run(args);
    }

    public void run(String[] args) {
        if (args.length < 2) {
            System.err.println("At least two arguments required");
            System.exit(1);
        }
        File outputDir = new File(args[0]);
        ArrayList<File> inputFiles = new ArrayList<File>();
        for (int i = 1; i < args.length; ++i) {
            inputFiles.add(new File(args[i]));
        }
        if (inputFiles.isEmpty()) {
            logger.error("No input file(s)/dir(s)");
            System.exit(1);
        }
        for (File inputFile : inputFiles) {
            try {
                if (inputFile.isDirectory()) {
                    File[] files;
                    for (File f : files = inputFile.listFiles()) {
                        this.copyFile(f, outputDir);
                    }
                    continue;
                }
                this.copyFile(inputFile, outputDir);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void copyFile(File inputFile, File outputDir) throws IOException {
        if (inputFile.isDirectory()) {
            File[] files = inputFile.listFiles();
            File newOutputDir = new File(outputDir, inputFile.getName());
            for (File f : files) {
                this.copyFile(f, newOutputDir);
            }
        } else {
            File outputFile = new File(outputDir, inputFile.getName());
            outputDir.mkdirs();
            logger.info(" copying " + inputFile + " to " + outputFile);
            FileUtils.copyFile((File)inputFile, (File)outputFile);
            if (inputFile.canExecute()) {
                outputFile.setExecutable(true);
            }
        }
    }
}

