/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fizzed.stork.core.ArgumentException;
import com.fizzed.stork.core.BaseApplication;
import com.fizzed.stork.core.Version;
import com.fizzed.stork.launcher.Configuration;
import com.fizzed.stork.launcher.ConfigurationFactory;
import com.fizzed.stork.launcher.FileUtil;
import com.fizzed.stork.launcher.Generator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;

public class LauncherMain
extends BaseApplication {
    public static void main(String[] args) {
        new LauncherMain().run(args);
    }

    public void printUsage() {
        System.out.println("Usage: stork-launcher -o <dir> <input>...");
        System.out.println("");
        System.out.println("Create console/daemon launchers for your Java apps. Input may");
        System.out.println("either be a file or include a wildcard to support searching.");
        System.out.println("");
        System.out.println("Arguments");
        System.out.println("");
        System.out.println(" -v, --version            Print version and exit");
        System.out.println(" -h, --help               Print help and exit");
        System.out.println(" -o, --output-dir <dir>   Output directory");
        System.out.println("");
    }

    public void run(Deque<String> args) {
        File outputDir = null;
        ArrayList<String> configFileStrings = new ArrayList<String>();
        block16: while (!args.isEmpty()) {
            String arg;
            switch (arg = args.remove()) {
                case "-v": 
                case "--version": {
                    System.out.println("stork-launcher " + Version.getLongVersion());
                    System.out.println(" by Fizzed, Inc. (http://fizzed.com)");
                    System.out.println(" at https://github.com/fizzed/stork");
                    System.exit(0);
                    continue block16;
                }
                case "-h": 
                case "--help": {
                    this.printUsage();
                    System.exit(0);
                    continue block16;
                }
                case "-o": 
                case "--output-dir": {
                    outputDir = new File(this.nextArg(arg, args));
                    continue block16;
                }
            }
            if (arg.startsWith("-")) {
                this.printErrorThenHelpHintAndExit("invalid argument [" + arg + "]");
                continue;
            }
            configFileStrings.add(arg);
        }
        if (outputDir == null) {
            this.printErrorThenHelpHintAndExit("output dir required");
        }
        if (configFileStrings.isEmpty()) {
            this.printErrorThenHelpHintAndExit("input file required");
        }
        Logger log = this.getLogger();
        this.logWelcomeMessage();
        try {
            List<File> configFiles = FileUtil.findAllFiles(configFileStrings, false);
            ConfigurationFactory configFactory = new ConfigurationFactory();
            List<Configuration> configs = configFactory.read(configFiles);
            int generated = new Generator().generate(configs, outputDir);
            log.info("Created " + generated + " launchers");
        }
        catch (ArgumentException e) {
            this.printErrorThenHelpHintAndExit(e.getMessage());
        }
        catch (IOException e) {
            log.error("Unable to cleanly generate launcher(s)", (Throwable)e);
            this.printErrorThenHelpHintAndExit(e.getMessage());
        }
    }
}

