/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzed.stork.launcher.ConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Merger {
    public static void merge(List<File> configFiles, File outputFile) throws IOException {
        if (configFiles == null || configFiles.isEmpty()) {
            throw new IllegalArgumentException("No input config files were found");
        }
        if (outputFile == null) {
            throw new IOException("no output file was specified");
        }
        ConfigurationFactory factory = new ConfigurationFactory();
        JsonNode mergedNode = null;
        for (File configFile : configFiles) {
            try {
                JsonNode updateNode = factory.createConfigNode(configFile);
                if (mergedNode == null) {
                    mergedNode = updateNode;
                    continue;
                }
                mergedNode = factory.mergeNodes(mergedNode, updateNode);
            }
            catch (Exception e) {
                throw new IOException("Config file [" + configFile + "] invalid");
            }
        }
        try {
            factory.getMapper().writeValue(outputFile, mergedNode);
            System.out.println("Wrote merged config file: " + outputFile);
        }
        catch (Exception e) {
            throw new IOException("Unable to cleanly write merged config");
        }
    }
}

