/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fizzed.stork.launcher.PlatformConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class Configuration {
    @JsonIgnore
    private File file;
    private String binDir = "bin";
    private String runDir = "run";
    private String shareDir = "share";
    private String logDir = "log";
    private String libDir = "lib";
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) Set<Platform> platforms;
    @NotNull
    private String name;
    private String displayName;
    @NotNull
    private String domain;
    @NotNull
    private String shortDescription;
    private String longDescription;
    @NotNull
    private String mainClass;
    @NotNull
    private Type type;
    private WorkingDirMode workingDirMode;
    private String appArgs = "";
    private String javaArgs = "";
    private String extraAppArgs = "";
    private String extraJavaArgs = "";
    private String minJavaVersion = "1.6";
    private String maxJavaVersion = null;
    private Integer minJavaMemory = null;
    private Integer maxJavaMemory = null;
    private Integer minJavaMemoryPct = null;
    private Integer maxJavaMemoryPct = null;
    private boolean includeJavaXrs = true;
    private boolean symlinkJava = false;
    private boolean includeJavaDetectHelper = false;
    private Integer daemonMinLifetime = 5;
    private Map<Platform, PlatformConfiguration> platformConfigurations = new HashMap<Platform, PlatformConfiguration>();
    private String systemdServiceSection;

    public Configuration() {
        PlatformConfiguration linuxConfig = new PlatformConfiguration();
        linuxConfig.setDaemonMethod(DaemonMethod.NOHUP);
        linuxConfig.setPrefixDir("/opt");
        this.platformConfigurations.put(Platform.LINUX, linuxConfig);
        PlatformConfiguration windowsConfig = new PlatformConfiguration();
        windowsConfig.setDaemonMethod(DaemonMethod.JSLWIN);
        this.platformConfigurations.put(Platform.WINDOWS, windowsConfig);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getBinDir() {
        return this.binDir;
    }

    public void setBinDir(String binDir) {
        this.binDir = binDir;
    }

    public String getShareDir() {
        return this.shareDir;
    }

    public void setShareDir(String shareDir) {
        this.shareDir = shareDir;
    }

    public String getRunDir() {
        return this.runDir;
    }

    public void setRunDir(String runDir) {
        this.runDir = runDir;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public Set<Platform> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Set<Platform> platforms) {
        this.platforms = platforms;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public WorkingDirMode getWorkingDirMode() {
        if (this.workingDirMode == null) {
            if (this.type == Type.CONSOLE) {
                return WorkingDirMode.RETAIN;
            }
            if (this.type == Type.DAEMON) {
                return WorkingDirMode.APP_HOME;
            }
        }
        return this.workingDirMode;
    }

    public void setWorkingDirMode(WorkingDirMode workingDirMode) {
        this.workingDirMode = workingDirMode;
    }

    public String getAppArgs() {
        return this.appArgs;
    }

    public void setAppArgs(String appArgs) {
        this.appArgs = appArgs;
    }

    public String getExtraAppArgs() {
        return this.extraAppArgs;
    }

    public void setExtraAppArgs(String extraAppArgs) {
        this.extraAppArgs = extraAppArgs;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public String getExtraJavaArgs() {
        return this.extraJavaArgs;
    }

    public void setExtraJavaArgs(String extraJavaArgs) {
        this.extraJavaArgs = extraJavaArgs;
    }

    public String getLibDir() {
        return this.libDir;
    }

    public void setLibDir(String libDir) {
        this.libDir = libDir;
    }

    public boolean isIncludeJavaXrs() {
        return this.includeJavaXrs;
    }

    public void setIncludeJavaXrs(boolean includeJavaXrs) {
        this.includeJavaXrs = includeJavaXrs;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public void setMinJavaVersion(String minJavaVersion) {
        this.minJavaVersion = minJavaVersion;
    }

    public String getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public void setMaxJavaVersion(String maxJavaVersion) {
        this.maxJavaVersion = maxJavaVersion;
    }

    public Integer getMinJavaMemory() {
        return this.minJavaMemory;
    }

    public void setMinJavaMemory(Integer minJavaMemory) {
        this.minJavaMemory = minJavaMemory;
    }

    public Integer getMaxJavaMemory() {
        return this.maxJavaMemory;
    }

    public void setMaxJavaMemory(Integer maxJavaMemory) {
        this.maxJavaMemory = maxJavaMemory;
    }

    public Integer getMinJavaMemoryPct() {
        return this.minJavaMemoryPct;
    }

    public void setMinJavaMemoryPct(Integer minJavaMemoryPct) {
        this.minJavaMemoryPct = minJavaMemoryPct;
    }

    public Integer getMaxJavaMemoryPct() {
        return this.maxJavaMemoryPct;
    }

    public void setMaxJavaMemoryPct(Integer maxJavaMemoryPct) {
        this.maxJavaMemoryPct = maxJavaMemoryPct;
    }

    public boolean isSymlinkJava() {
        return this.symlinkJava;
    }

    public void setSymlinkJava(boolean symlinkJava) {
        this.symlinkJava = symlinkJava;
    }

    public boolean isIncludeJavaDetectHelper() {
        return this.includeJavaDetectHelper;
    }

    public void setIncludeJavaDetectHelper(boolean includeJavaDetectHelper) {
        this.includeJavaDetectHelper = includeJavaDetectHelper;
    }

    public Integer getDaemonMinLifetime() {
        return this.daemonMinLifetime;
    }

    public void setDaemonMinLifetime(Integer daemonMinLifetime) {
        this.daemonMinLifetime = daemonMinLifetime;
    }

    public Map<Platform, PlatformConfiguration> getPlatformConfigurations() {
        return this.platformConfigurations;
    }

    public void setPlatformConfigurations(Map<Platform, PlatformConfiguration> platformConfigurations) {
        this.platformConfigurations = platformConfigurations;
    }

    public PlatformConfiguration getPlatformConfiguration(Platform platform) {
        if (platform == null) {
            return null;
        }
        return this.platformConfigurations.get((Object)platform);
    }

    public DaemonMethod getPlatformDaemonMethod(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformDaemonMethod(platform);
    }

    public DaemonMethod getPlatformDaemonMethod(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        DaemonMethod v = pc.getDaemonMethod();
        if (v == null && platform == Platform.MAC_OSX) {
            return this.getPlatformDaemonMethod(Platform.LINUX);
        }
        return v;
    }

    public String getPlatformUser(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformUser(platform);
    }

    public String getPlatformUser(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        String v = pc.getUser();
        if (v == null && platform == Platform.MAC_OSX) {
            return this.getPlatformUser(Platform.LINUX);
        }
        return v;
    }

    public String getPlatformGroup(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformUser(platform);
    }

    public String getPlatformGroup(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        String v = pc.getGroup();
        if (v == null && platform == Platform.MAC_OSX) {
            return this.getPlatformGroup(Platform.LINUX);
        }
        return v;
    }

    public String getPlatformPrefixDir(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformPrefixDir(platform);
    }

    public String getPlatformPrefixDir(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        String v = pc.getPrefixDir();
        if (v == null && platform == Platform.MAC_OSX) {
            return this.getPlatformPrefixDir(Platform.LINUX);
        }
        return v;
    }

    public String getPlatformLogDir(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformLogDir(platform);
    }

    public String getPlatformLogDir(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        String v = pc.getLogDir();
        return v;
    }

    public String getPlatformRunDir(String platformName) {
        Platform platform = Platform.valueOf(platformName);
        return this.getPlatformRunDir(platform);
    }

    public String getPlatformRunDir(Platform platform) {
        PlatformConfiguration pc = this.getPlatformConfiguration(platform);
        if (pc == null) {
            return null;
        }
        String v = pc.getRunDir();
        return v;
    }

    public String getSystemdServiceSection() {
        return this.systemdServiceSection;
    }

    public void setSystemdServiceSection(String systemdServiceSection) {
        this.systemdServiceSection = systemdServiceSection;
    }

    public static enum DaemonMethod {
        NOHUP,
        JSLWIN,
        WINSW;

    }

    public static enum WorkingDirMode {
        RETAIN,
        APP_HOME;

    }

    public static enum Type {
        CONSOLE,
        DAEMON;

    }

    public static enum Platform {
        LINUX,
        MAC_OSX,
        WINDOWS;

    }
}

