/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.maven;

import com.fizzed.stork.assembly.AssemblyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="assembly", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AssemblyMojo
extends AbstractMojo {
    @Parameter(property="stageDirectory", defaultValue="${project.build.directory}/stork", required=true)
    protected File stageDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(property="finalName", defaultValue="${project.build.finalName}", required=true)
    protected String finalName;
    @Parameter(property="skipArtifactsThatAreDirectories", defaultValue="false", required=true)
    protected Boolean skipArtifactsThatAreDirectories;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.stageDirectory.exists()) {
            this.getLog().info((CharSequence)("Creating stage directory: " + this.stageDirectory));
            this.stageDirectory.mkdirs();
        }
        try {
            File shareDir;
            File confDir;
            List<Artifact> artifacts = this.artifactsToStage();
            File stageLibDir = new File(this.stageDirectory, "lib");
            for (Artifact a : artifacts) {
                File f = a.getFile();
                if (f == null) {
                    this.getLog().error((CharSequence)"Project artifact was null (maybe not compiled into jar yet?)");
                    continue;
                }
                StringBuilder jarFileName = new StringBuilder();
                jarFileName.append(a.getGroupId()).append(".");
                jarFileName.append(a.getArtifactId()).append("-");
                jarFileName.append(a.getVersion());
                if (a.getClassifier() != null && !a.getClassifier().trim().isEmpty()) {
                    jarFileName.append("-");
                    jarFileName.append(a.getClassifier());
                }
                jarFileName.append(".").append(a.getType());
                File stageArtificateFile = new File(stageLibDir, jarFileName.toString());
                if (f.isDirectory()) {
                    if (this.skipArtifactsThatAreDirectories.booleanValue()) {
                        this.getLog().debug((CharSequence)("Artifact " + f + " is a directory (skipping)"));
                        continue;
                    }
                    throw new MojoFailureException("Artifact " + f + " is a directory! (won't be able to copy it). Maybe skipArtificatsThatAreDirectories would help?");
                }
                this.getLog().debug((CharSequence)("Copying artifact " + f + " to " + stageArtificateFile));
                FileUtils.copyFile((File)f, (File)stageArtificateFile);
            }
            File binDir = new File(this.project.getBasedir(), "bin");
            if (binDir.exists()) {
                File stageBinDir = new File(this.stageDirectory, "bin");
                FileUtils.copyDirectory((File)binDir, (File)stageBinDir);
            }
            if ((confDir = new File(this.project.getBasedir(), "conf")).exists()) {
                File stageConfDir = new File(this.stageDirectory, "conf");
                FileUtils.copyDirectory((File)confDir, (File)stageConfDir);
            }
            if ((shareDir = new File(this.project.getBasedir(), "share")).exists()) {
                File stageShareDir = new File(this.stageDirectory, "share");
                FileUtils.copyDirectory((File)shareDir, (File)stageShareDir);
            }
            AssemblyUtils.copyStandardProjectResources((File)this.project.getBasedir(), (File)this.stageDirectory);
            File tgzFile = AssemblyUtils.createTGZ((File)this.outputDirectory, (File)this.stageDirectory, (String)this.finalName);
            this.getLog().info((CharSequence)("Generated maven stork assembly: " + tgzFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public List<Artifact> artifactsToStage() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (!this.shouldArtifactBeStaged(this.project.getArtifact())) {
            this.getLog().info((CharSequence)"Project artifact may have a classifier or is not of type jar (will not be staged)");
        } else {
            artifacts.add(this.project.getArtifact());
        }
        for (Artifact a : this.project.getAttachedArtifacts()) {
            if (!this.shouldArtifactBeStaged(a)) continue;
            artifacts.add(a);
        }
        for (Artifact a : this.project.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            artifacts.add(a);
        }
        return artifacts;
    }

    public boolean shouldArtifactBeStaged(Artifact a) {
        return !a.hasClassifier() && (a.getType() == null || a.getType().equalsIgnoreCase("jar"));
    }
}

