/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.maven;

import com.fizzed.stork.core.ArgumentException;
import com.fizzed.stork.launcher.ConfigurationFactory;
import com.fizzed.stork.launcher.FileUtil;
import com.fizzed.stork.launcher.Generator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="launcher", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class LauncherMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/stork", required=true)
    protected File outputDirectory;
    @Parameter(property="inputFiles", defaultValue="${basedir}/src/main/launchers")
    protected String[] inputFiles;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDirectory == null || this.outputDirectory.equals("")) {
            this.getLog().info((CharSequence)"Skipping (outputDirectory is empty)");
            return;
        }
        try {
            List configFiles = FileUtil.findAllFiles(Arrays.asList(this.inputFiles), (boolean)true);
            List configs = new ConfigurationFactory().read(configFiles);
            int generated = new Generator().generate(configs, this.outputDirectory);
            this.getLog().info((CharSequence)("Created " + generated + " launchers"));
        }
        catch (ArgumentException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

