/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.core.flow;

import com.fizzgate.aggregate.core.exception.ExecuteScriptException;
import com.fizzgate.aggregate.core.flow.FlowContext;
import com.fizzgate.aggregate.core.flow.INode;
import com.fizzgate.aggregate.core.flow.NodeConfig;
import com.fizzgate.aggregate.core.flow.NodeResponse;
import com.fizzgate.aggregate.core.flow.behavior.B;
import com.fizzgate.aggregate.core.flow.behavior.Object;
import com.fizzgate.aggregate.core.flow.behavior.String;
import com.fizzgate.aggregate.core.script.ScriptExecutor;
import com.fizzgate.aggregate.core.util.JacksonUtils;
import com.fizzgate.aggregate.core.util.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptException;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public abstract class Node<NODE_CONFIG extends NodeConfig>
implements INode {
    private static final Logger o00000 = LoggerFactory.getLogger(Node.class);
    protected final java.lang.String name;
    protected final NODE_CONFIG config;
    protected final FlowContext context;
    protected final List<B> behaviors;

    public Node(NODE_CONFIG NODE_CONFIG, FlowContext flowContext) {
        this.config = NODE_CONFIG;
        this.context = flowContext;
        this.name = ((NodeConfig)NODE_CONFIG).getName();
        this.behaviors = Object.o00000(((NodeConfig)NODE_CONFIG).getComponents(), this);
    }

    @Override
    public java.lang.String getName() {
        return this.name;
    }

    @Override
    public FlowContext getContext() {
        return this.context;
    }

    @Override
    public NodeConfig getConfig() {
        return this.config;
    }

    @Override
    public void beforeRun() {
    }

    @Override
    public boolean needRun() {
        Map<java.lang.String, java.lang.Object> map = ((NodeConfig)this.config).getCondition();
        if (CollectionUtils.isEmpty(map)) {
            return Boolean.TRUE;
        }
        ONode oNode = this.context.toONode();
        try {
            Boolean bl = ScriptExecutor.execute(map, oNode, this.context, Boolean.class);
            return bl != null ? bl : Boolean.TRUE;
        }
        catch (ScriptException scriptException) {
            LogUtils.warn(o00000, this.context.getTraceId(), "execute script failed, {}", JacksonUtils.writeValueAsString(map), scriptException);
            throw new ExecuteScriptException(scriptException, this.context, map);
        }
    }

    @Override
    public Mono<NodeResponse> run() {
        List<B> list = this.getBehaviors();
        if (CollectionUtils.isEmpty(list)) {
            return this.o00000();
        }
        Mono<NodeResponse> mono = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            B b = list.get(i);
            String string = b.o00000(this::o00000, i + 1 == n);
            mono = string.\u00d200000();
            if (string.o00000().booleanValue()) break;
        }
        return mono;
    }

    public abstract Mono<NodeResponse> singleRun();

    public List<B> getBehaviors() {
        return this.behaviors;
    }

    private Mono<NodeResponse> o00000() {
        this.beforeRun();
        if (this.needRun()) {
            return this.singleRun();
        }
        NodeResponse nodeResponse = new NodeResponse(this, Collections.emptyMap(), ((NodeConfig)this.config).isStop());
        return Mono.just((java.lang.Object)nodeResponse);
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        INode iNode = (INode)object;
        return this.name.equals(iNode.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

