/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.core.flow;

import com.fizzgate.aggregate.core.exception.FizzRuntimeException;
import com.fizzgate.aggregate.core.flow.ContainerNode;
import com.fizzgate.aggregate.core.flow.EndNode;
import com.fizzgate.aggregate.core.flow.FlowContext;
import com.fizzgate.aggregate.core.flow.INode;
import com.fizzgate.aggregate.core.flow.INodeBuilder;
import com.fizzgate.aggregate.core.flow.StartNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class NodeFactory {
    private static final Logger \u00d200000 = LoggerFactory.getLogger(NodeFactory.class);
    private static final Map<String, INodeBuilder> o00000 = new ConcurrentHashMap<String, INodeBuilder>(8);

    public static synchronized void registerBuilder(String string, INodeBuilder iNodeBuilder) {
        Assert.notNull((Object)string, (String)"type cannot be null");
        Assert.notNull((Object)iNodeBuilder, (String)"nodeBuilder cannot be null");
        if (o00000.containsKey(string) && !iNodeBuilder.getClass().equals(o00000.get(string).getClass())) {
            throw new IllegalStateException(String.format("try to add node builder[%s] but exist [type:%s, exist:%s]", iNodeBuilder.getClass().getName(), string, o00000.get(string).getClass().getName()));
        }
        o00000.put(string, iNodeBuilder);
    }

    public static INode buildNode(Map<String, Object> map, FlowContext flowContext) {
        String string = map.get("type").toString();
        INodeBuilder iNodeBuilder = o00000.get(string);
        if (iNodeBuilder == null) {
            throw new FizzRuntimeException(String.format("can't find node type:%s", string));
        }
        return iNodeBuilder.build(map, flowContext);
    }

    static {
        NodeFactory.registerBuilder("START", new StartNode.StartNodeBuilder());
        NodeFactory.registerBuilder("END", new EndNode.EndNodeBuilder());
        NodeFactory.registerBuilder("CONTAINER", new ContainerNode.ContainerNodeBuilder());
    }
}

