/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.core.script;

import com.alibaba.fastjson.JSON;
import com.fizzgate.aggregate.core.exception.ExecuteScriptException;
import com.fizzgate.aggregate.core.exception.RedirectException;
import com.fizzgate.aggregate.core.exception.StopAndResponseException;
import com.fizzgate.aggregate.core.flow.FlowContext;
import com.fizzgate.aggregate.core.flow.PathMapping;
import com.fizzgate.aggregate.core.util.JacksonUtils;
import com.fizzgate.aggregate.core.util.Script;
import com.fizzgate.aggregate.core.util.ScriptUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ScriptExecutor {
    private static final Logger o00000 = LoggerFactory.getLogger(ScriptExecutor.class);
    public static final String STOP_AND_RESPONSE_KEY = "_stopAndResponse";
    public static final String REDIRECT_URL_KEY = "_redirectUrl";

    public static Object execute(Map<String, Object> map, ONode oNode, FlowContext flowContext) throws ScriptException {
        return ScriptExecutor.execute(map, oNode, flowContext, Object.class);
    }

    public static <T> T execute(Map<String, Object> map, ONode oNode, FlowContext flowContext, Class<T> clazz) throws ScriptException {
        Script script = new Script();
        script.setType((String)map.get("type"));
        script.setSource((String)map.get("source"));
        if (!StringUtils.hasText((String)script.getType()) || !StringUtils.hasText((String)script.getSource())) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("context", flowContext);
        Object object = ScriptUtils.execute(script, hashMap);
        if ("groovy".equals(script.getType())) {
            return (T)ScriptExecutor.handleStopResponse(flowContext, object);
        }
        if ("javascript".equals(script.getType())) {
            if (object != null) {
                if (object instanceof Collection || object instanceof Map) {
                    return (T)object;
                }
                String string = object.toString();
                if (string.startsWith("[") && string.endsWith("]")) {
                    return (T)JSON.parseArray((String)string).toJavaObject(clazz);
                }
                if (string.startsWith("{") && string.endsWith("}")) {
                    if (clazz.isAssignableFrom(Map.class)) {
                        return (T)ScriptExecutor.handleStopResponse(flowContext, JSON.parseObject((String)string).toJavaObject(clazz));
                    }
                    ScriptExecutor.handleStopResponse(flowContext, JSON.parseObject((String)string).toJavaObject(Map.class));
                    return (T)JSON.parseObject((String)string).toJavaObject(clazz);
                }
                return (T)object;
            }
            return null;
        }
        return (T)object;
    }

    public static Map<String, Object> executeScripts(ONode oNode, Map<String, Object> map, ONode oNode2, FlowContext flowContext, boolean bl) {
        return ScriptExecutor.executeScripts(oNode, map, oNode2, flowContext, Object.class, bl);
    }

    public static <T> Map<String, T> executeScripts(ONode oNode, Map<String, Object> map, ONode oNode2, FlowContext flowContext, Class<T> clazz, boolean bl) {
        if (oNode == null) {
            oNode = ONode.load(new HashMap());
        }
        if (map != null && !map.isEmpty()) {
            Object var6_6 = null;
            String string = null;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Map map2 = (Map)entry.getValue();
                try {
                    if ("*".equals(entry.getKey())) {
                        var6_6 = ScriptExecutor.execute(map2, oNode2, flowContext, clazz);
                        string = entry.getKey();
                        continue;
                    }
                    PathMapping.setByPath(oNode, entry.getKey(), ScriptExecutor.execute(map2, oNode2, flowContext, clazz), bl);
                }
                catch (ScriptException scriptException) {
                    o00000.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString(map2), (Object)scriptException);
                    throw new ExecuteScriptException(scriptException, flowContext, (Object)map2);
                }
            }
            if (string != null) {
                PathMapping.setByPath(oNode, string, var6_6, bl);
            }
        }
        return (Map)oNode.toObject(Map.class);
    }

    public static Object handleStopResponse(FlowContext flowContext, Object object) {
        Map map;
        if (object instanceof Map && (map = (Map)object).containsKey(STOP_AND_RESPONSE_KEY)) {
            if (map.get(STOP_AND_RESPONSE_KEY) != null && map.get(STOP_AND_RESPONSE_KEY) instanceof Boolean && ((Boolean)map.get(STOP_AND_RESPONSE_KEY)).booleanValue()) {
                map.remove(STOP_AND_RESPONSE_KEY);
                if (map.get(REDIRECT_URL_KEY) != null) {
                    throw new RedirectException("stop and redirect", String.valueOf(map.get(REDIRECT_URL_KEY)));
                }
                if (flowContext.returnContext()) {
                    map.put("_context", flowContext);
                }
                throw new StopAndResponseException("stop and response", JSON.toJSONString((Object)map));
            }
            map.remove(STOP_AND_RESPONSE_KEY);
        }
        return object;
    }
}

