/**
 * context 上下文便捷操作函数
 *
 */
var common = {
		/* *********** private function begin *********** */

		/**
		 * 获取上下文中客户端请求对象
		 * @param {*} ctx 上下文 【必填】
		 */
		getInputReq: function (ctx){
		    if(!ctx || !ctx['input'] || !ctx['input']['request']){
		        return {};
		    }
		    return ctx['input']['request']
		},

		/**
		 * 获取上下文节点请求接口的请求对象
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 */
		getNodeReq: function (ctx, nodeName){
		    if(!ctx || !nodeName){
		        return {};
		    }
		    if(!ctx['node'] || !ctx['node'][nodeName] || !ctx['node'][nodeName]['request']){
		        return {};
		    }
		    return ctx['node'][nodeName]['request'];
		},

		/**
		 * 获取上下文节点中请求接口的响应对象
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 */
		getNodeResp: function (ctx, nodeName){
			if(!ctx || !nodeName){
				return {};
			}
			if(!ctx['node'] || !ctx['node'][nodeName] || !ctx['node'][nodeName]['response']){
				return {};
			}
			return ctx['node'][nodeName]['response'];
		},

		/* *********** private function end *********** */

		/* *********** input begin ************ */

		/**
		 * 获取客户端请求头
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} headerName 请求头字段名 【选填】，不传时返回所有请求头
		 */
		getInputReqHeader: function (ctx, headerName){
		    var req = this.getInputReq(ctx);
		    var headers = req['headers'] || {};
		    return headerName ? headers[headerName.toUpperCase()] : headers;
		},

		/**
		 * 获取客户端URL请求参数（query string）
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} paramName URL参数名 【选填】，不传时返回所有请求参数
		 */
		getInputReqParam: function (ctx, paramName){
		    var req = this.getInputReq(ctx);
		    var params = req['params'] || {};
		    return paramName ? params[paramName] : params;
		},

		/**
		 * 获取客户端请求体
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} field 字段名 【选填】，不传时返回整个请求体
		 */
		getInputReqBody: function (ctx, field){
		    var req = this.getInputReq(ctx);
		    var body = req['body'] || {};
		    return field ? body[field] : body;
		},

		/**
		 * 获取返回给客户端的响应头
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} headerName 响应头字段名 【选填】，不传时返回所有响应头
		 */
		getInputRespHeader: function (ctx, headerName){
		    var req = this.getInputReq(ctx);
		    var headers = req['headers'] || {};
		    return headerName ? headers[headerName.toUpperCase()] : headers;
		},

		/**
		 * 获取返回给客户端的响应体
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} field 字段名 【选填】，不传时返回整个响应体
		 */
		getInputRespBody: function (ctx, field){
		    var req = this.getInputReq(ctx);
		    var body = req['body'] || {};
		    return field ? body[field] : body;
		},

		/* *********** input begin ************ */

		/* *********** node request begin ************ */

		/**
		 * 获取节点中调用的接口的请求头
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} headerName 请求头字段名 【选填】，不传时返回所有请求头
		 */
		getNodeReqHeader: function (ctx, nodeName, headerName){
		    var req = this.getNodeReq(ctx, nodeName);
		    var headers = req['headers'] || {};
		    return headerName ? headers[headerName.toUpperCase()] : headers;
		},

		/**
		 * 获取节点中调用的接口的URL参数
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} paramName URL参数名 【选填】，不传时返回所有URL参数
		 */
		getNodeReqParam: function (ctx, nodeName, paramName){
		    var req = this.getNodeReq(ctx, nodeName);
		    var params = req['params'] || {};
		    return paramName ? params[paramName] : params;
		},

		/**
		 * 获取节点中调用的接口的请求体
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} field 字段名 【选填】，不传时返回整个请求体
		 */
		getNodeReqBody: function (ctx, nodeName, field){
		    var req = this.getNodeReq(ctx, nodeName);
		    var body = req['body'] || {};
		    return field ? body[field] : body;
		},

		/**
		 * 获取节点中调用的接口的响应头
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} headerName 响应头字段名 【选填】，不传时返回所有响应头
		 */
		getNodeRespHeader: function (ctx, nodeName, headerName){
		    var resp = this.getNodeResp(ctx, nodeName);
		    var headers = resp['headers'] || {};
		    return headerName ? headers[headerName.toUpperCase()] : headers;
		},

		/**
		 * 获取节点中调用的接口的响应体
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} field 字段名 【选填】，不传时返回整个响应体
		 */
		getNodeRespBody: function (ctx, nodeName, field){
		    var resp = this.getNodeResp(ctx, nodeName);
		    var body = resp['body'] || {};
		    return field ? body[field] : body;
		},

		/**
		 * 获取节点结果
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 * @param {*} field 字段名 【选填】，不传时返回整个节点结果对象
		 */
		getNodeResult: function (ctx, nodeName, field){
		    if(!ctx || !nodeName || !ctx['node'] || !ctx['node'][nodeName]){
		        return {};
		    }
		    var result = ctx['node'][nodeName]['result'] || {};
		    return field ? result[field] : result;
		},

		/**
		 * 获取节点循环结果
		 * @param {*} ctx 上下文 【必填】
		 * @param {*} nodeName 节点名称 【必填】
		 */
		getNodeCircle: function (ctx, nodeName){
		    if(!ctx || !nodeName || !ctx['node'] || !ctx['node'][nodeName]){
		        return null;
		    }
		    // 返回循环结果数组
		    return ctx['node'][nodeName]['circle'];
		}

		/* *********** node request end ************ */

		,/**
			 ** 乘法函数，用来得到精确的乘法结果
			 ** 说明：javascript的乘法结果会有误差，在两个浮点数相乘的时候会比较明显。这个函数返回较为精确的乘法结果。
			 ** 调用：accMul(arg1,arg2)
			 ** 返回值：arg1乘以 arg2的精确结果
			 **/
			accMul:function (arg1, arg2) {
			var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
			try {
				m += s1.split(".")[1].length;
			} catch (e) {
			}
			try {
				m += s2.split(".")[1].length;
			} catch (e) {
			}
			return Number(s1.replace(".", "")) * Number(s2.replace(".", ""))
				/ Math.pow(10, m);
		},

			/**
			 ** 除法函数，用来得到精确的除法结果
			 ** 说明：javascript的除法结果会有误差，在两个浮点数相除的时候会比较明显。这个函数返回较为精确的除法结果。
			 ** 调用：accDiv(arg1,arg2)
			 ** 返回值：arg1除以arg2的精确结果
			 **/
			accDiv:function (arg1, arg2) {
			var t1 = 0, t2 = 0, r1, r2;
			try {
				t1 = arg1.toString().split(".")[1].length;
			} catch (e) {
			}
			try {
				t2 = arg2.toString().split(".")[1].length;
			} catch (e) {
			}
			with (Math) {
				r1 = Number(arg1.toString().replace(".", ""));
				r2 = Number(arg2.toString().replace(".", ""));
				return (r1 / r2) * pow(10, t2 - t1);
			}
		}


};


