/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.PropertiesSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalPropertiesValidator.class);
    private final boolean allowAdditionalProperties;
    private final JsonSchema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<Pattern> patternProperties = new ArrayList<Pattern>();

    public AdditionalPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ADDITIONAL_PROPERTIES, validationContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema).initialize();
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        this.allowedProperties = new HashSet<String>();
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            Iterator it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                this.allowedProperties.add((String)it.next());
            }
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            Iterator it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                this.patternProperties.add(Pattern.compile((String)it.next()));
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            this.debug(logger, node, rootNode, at);
        }
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isObject()) {
            return errors;
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (Pattern pattern : this.patternProperties) {
                Matcher m = pattern.matcher(pname);
                if (!m.find()) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties) continue;
            if (!this.allowAdditionalProperties) {
                errors.add(this.buildValidationMessage(at, pname));
                continue;
            }
            if (this.additionalPropertiesSchema == null) continue;
            JsonNode jsonNode = node.get(pname);
            if (jsonNode == null && PropertiesSupportUtils.supportPropertyUpperCase()) {
                jsonNode = node.get(pname.toUpperCase());
            }
            errors.addAll(this.additionalPropertiesSchema.validate(jsonNode, rootNode, at + "." + pname));
        }
        return Collections.unmodifiableSet(errors);
    }
}

