/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.CustomErrorMessageType;
import com.fizzgate.schema.ErrorMessageType;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonSchemaException;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.SchemaValidatorsConfig;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorState;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
implements JsonValidator {
    private String schemaPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private boolean suppressSubSchemaRetrieval;
    private ValidatorTypeCode validatorType;
    private ErrorMessageType errorMessageType;
    protected SchemaValidatorsConfig config;
    protected final boolean failFast;
    protected static final ThreadLocal<ValidatorState> validatorState = new ThreadLocal();

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaPath, schemaNode, parentSchema, validatorType, false, validationContext.getConfig() != null && validationContext.getConfig().isFailFast());
        this.config = validationContext.getConfig() == null ? new SchemaValidatorsConfig() : validationContext.getConfig();
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, boolean suppressSubSchemaRetrieval, boolean failFast) {
        this.errorMessageType = validatorType;
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        this.failFast = failFast;
    }

    protected String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    protected JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        URI uri;
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals((Object)schemaNode.get("$schema"))) {
            return null;
        }
        String text = node.textValue();
        if (text == null) {
            return null;
        }
        try {
            uri = validationContext.getURIFactory().create(node.textValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return validationContext.getJsonSchemaFactory().getSchema(uri, validationContext.getConfig());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        List<String> nameWithContextLocaleList = I18nUtils.getNameWithContextLocaleList(errorCodeKey);
        for (String nameWithContextLocale : nameWithContextLocaleList) {
            String errorCodeText;
            JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(nameWithContextLocale);
            if (errorCodeNode == null || !errorCodeNode.isTextual() || !StringUtils.isNotBlank((CharSequence)(errorCodeText = errorCodeNode.asText()))) continue;
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
            break;
        }
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        ValidationMessage message = ValidationMessage.of(this.getValidatorType().getValue(), this.errorMessageType, at, arguments);
        if (this.failFast) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( " + node + ", " + rootNode + ", " + at + ")");
        }
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }
}

