/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.DateTimeValidator;
import com.fizzgate.schema.Format;
import com.fizzgate.schema.FormatValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.Keyword;
import com.fizzgate.schema.UUIDValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.format.EmailValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class FormatKeyword
implements Keyword {
    private final ValidatorTypeCode type;
    private final Map<String, Format> formats;
    private final String DATE = "date";
    private final String DATE_TIME = "date-time";
    private final String UUID = "uuid";
    private final String EMAIL = "email";

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this.type = type;
        this.formats = formats;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws Exception {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
            if (formatName.equals("date") || formatName.equals("date-time")) {
                return new DateTimeValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
            if (formatName.equals("uuid")) {
                return new UUIDValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
            if (formatName.equals("email")) {
                return new EmailValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
        }
        return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format);
    }

    @Override
    public String getValue() {
        return this.type.getValue();
    }
}

