/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.Format;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonType;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.TypeFactory;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.FORMAT, validationContext);
        this.format = format;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (this.format != null) {
            try {
                if (!this.format.matches(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on " + at + ": Invalid RE syntax [" + this.format.getName() + "]", (Throwable)pse);
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

