/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ItemsValidator.class);
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private JsonSchema schema;
    private List<JsonSchema> tupleSchema;
    private boolean additionalItems = true;
    private JsonSchema additionalSchema;

    public ItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS, validationContext);
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            this.schema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema).initialize();
        } else {
            this.tupleSchema = new ArrayList<JsonSchema>();
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), s, parentSchema).initialize());
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                if (addItemNode.isBoolean()) {
                    this.additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    this.additionalSchema = new JsonSchema(validationContext, parentSchema.getCurrentUri(), addItemNode).initialize();
                }
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isArray() && !this.config.isTypeLoose()) {
            return errors;
        }
        if (node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                this.doValidate(errors, i, n, rootNode, at);
                ++i;
            }
        } else {
            this.doValidate(errors, 0, node, rootNode, at);
        }
        return Collections.unmodifiableSet(errors);
    }

    private void doValidate(Set<ValidationMessage> errors, int i, JsonNode node, JsonNode rootNode, String at) {
        if (this.schema != null) {
            errors.addAll(this.schema.validate(node, rootNode, at + "[" + i + "]"));
        }
        if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                errors.addAll(this.tupleSchema.get(i).validate(node, rootNode, at + "[" + i + "]"));
            } else if (this.additionalSchema != null) {
                errors.addAll(this.additionalSchema.validate(node, rootNode, at + "[" + i + "]"));
            } else if (!this.additionalItems) {
                errors.add(this.buildValidationMessage(at, "" + i));
            }
        }
    }
}

