/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonType;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.TypeFactory;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaxLengthValidator.class);
    private int maxLength = Integer.MAX_VALUE;

    public MaxLengthValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_LENGTH, validationContext);
        if (schemaNode != null && schemaNode.isIntegralNumber()) {
            this.maxLength = schemaNode.intValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != JsonType.STRING) {
            return Collections.emptySet();
        }
        if (node.textValue().codePointCount(0, node.textValue().length()) > this.maxLength) {
            String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
            return Collections.singleton(this.buildValidationMessage(at, "" + this.maxLength, title));
        }
        return Collections.emptySet();
    }
}

