/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MinItemsValidator.class);
    private int min = 0;

    public MinItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MIN_ITEMS, validationContext);
        if (schemaNode.isIntegralNumber()) {
            this.min = schemaNode.intValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (node.isArray()) {
            if (node.size() < this.min) {
                String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
                return Collections.singleton(this.buildValidationMessage(at, "" + this.min, title));
            }
        } else if (this.config.isTypeLoose() && 1 < this.min) {
            String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
            return Collections.singleton(this.buildValidationMessage(at, "" + this.min, title));
        }
        return Collections.emptySet();
    }
}

