/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.RequiredValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private JsonSchema schema;

    public NotValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.NOT, validationContext);
        this.schema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema).initialize();
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        Set<ValidationMessage> errors = this.schema.validate(node, rootNode, at);
        if (errors.isEmpty()) {
            return Collections.singleton(this.buildValidationMessage(at, this.schema.toString()));
        }
        return Collections.emptySet();
    }
}

