/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.schema.BaseJsonValidator;
import com.fizzgate.schema.JsonSchema;
import com.fizzgate.schema.JsonValidator;
import com.fizzgate.schema.ValidationContext;
import com.fizzgate.schema.ValidationMessage;
import com.fizzgate.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import com.fizzgate.schema.util.PropertiesSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<String> fieldNames = new ArrayList<String>();

    public RequiredValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REQUIRED, validationContext);
        if (schemaNode.isArray()) {
            for (JsonNode fieldNme : schemaNode) {
                this.fieldNames.add(fieldNme.asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (String fieldName : this.fieldNames) {
            JsonNode fieldJsonNode;
            String tmpTitle;
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode == null && PropertiesSupportUtils.supportPropertyUpperCase()) {
                propertyNode = node.get(fieldName.toUpperCase());
            }
            if (propertyNode != null) continue;
            String title = fieldName;
            JsonNode propertiesJsonNode = super.getParentSchema().getSchemaNode().get("properties");
            if (propertiesJsonNode != null && (tmpTitle = I18nUtils.getTitle(fieldJsonNode = propertiesJsonNode.get(fieldName))) != null) {
                title = tmpTitle;
            }
            errors.add(this.buildValidationMessage(at, fieldName, title));
        }
        return Collections.unmodifiableSet(errors);
    }
}

