/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.schema.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class I18nUtils {
    private static ThreadLocal<Locale> THREAD_LOCAL_LOCALE = new ThreadLocal();
    private static Locale DEFAULT_LOCALE = new Locale("zh");

    private I18nUtils() {
    }

    public static void setContextLocale(Locale locale) {
        THREAD_LOCAL_LOCALE.set(locale);
    }

    public static void removeContextLocale() {
        THREAD_LOCAL_LOCALE.remove();
    }

    public static Locale getContextLocale() {
        Locale locale = THREAD_LOCAL_LOCALE.get();
        if (locale == null) {
            return DEFAULT_LOCALE;
        }
        return locale;
    }

    public static List<String> getNameWithContextLocaleList(String baseName) {
        ArrayList<String> nameWithContextLocaleList = new ArrayList<String>(5);
        nameWithContextLocaleList.add(0, baseName);
        Locale locale = I18nUtils.getContextLocale();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (language != null && language.length() > 0) {
            nameWithContextLocaleList.add(0, String.format("%s_%s", baseName, language));
            String langLowerCaseWithFirstCharacterUpper = I18nUtils.toLowerCaseWithFirstCharacterUpper(language);
            nameWithContextLocaleList.add(0, String.format("%s%s", baseName, langLowerCaseWithFirstCharacterUpper));
            if (country != null && country.length() > 0) {
                nameWithContextLocaleList.add(0, String.format("%s_%s_%s", baseName, language, country));
                nameWithContextLocaleList.add(0, String.format("%s%s%s", baseName, langLowerCaseWithFirstCharacterUpper, I18nUtils.toLowerCaseWithFirstCharacterUpper(country)));
            }
        }
        return nameWithContextLocaleList;
    }

    public static String getTitle(JsonNode fieldJsonNode) {
        if (fieldJsonNode != null) {
            List<String> nameWithContextLocaleList = I18nUtils.getNameWithContextLocaleList("title");
            for (String nameWithContextLocale : nameWithContextLocaleList) {
                JsonNode titleJsonNode = fieldJsonNode.get(nameWithContextLocale);
                if (titleJsonNode == null) continue;
                return titleJsonNode.textValue();
            }
        }
        return null;
    }

    private static String getFieldName(String at) {
        if (at == null) {
            return null;
        }
        int lastIndexOfDot = at.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return null;
        }
        if (lastIndexOfDot == at.length() - 1) {
            return null;
        }
        return at.substring(lastIndexOfDot + 1);
    }

    public static String getTitle(JsonNode fieldJsonNode, String at) {
        String title = I18nUtils.getFieldName(at);
        String extractTitle = I18nUtils.getTitle(fieldJsonNode);
        if (extractTitle != null) {
            title = extractTitle;
        }
        return title;
    }

    private static String toLowerCaseWithFirstCharacterUpper(String str) {
        StringBuilder sb = new StringBuilder(str.toLowerCase());
        sb.replace(0, 1, Character.toString(Character.toUpperCase(sb.charAt(0))));
        return sb.toString();
    }
}

