package com.fizzgate.aggregate;

import com.fizzgate.aggregate.core.flow.NodeFactory;
import com.fizzgate.aggregate.core.util.GlobalResourceUtils;
import com.fizzgate.aggregate.web.filter.AggregateFilter;
import com.fizzgate.aggregate.web.filter.AggregateFilterProperties;
import com.fizzgate.aggregate.web.flow.extension.dubbo.DubboNode;
import com.fizzgate.aggregate.web.flow.extension.grpc.GrpcNode;
import com.fizzgate.aggregate.web.flow.extension.request.RequestNode;
import com.fizzgate.aggregate.web.listener.AggregateChannelListener;
import com.fizzgate.aggregate.web.loader.AppConfigProperties;
import com.fizzgate.aggregate.web.loader.ConfigLoader;
import com.fizzgate.aggregate.web.loader.ConfigLoaderProperties;
import com.fizzgate.aggregate.web.util.ApplicationContextUtils;
import com.fizzgate.aggregate.web.util.GlobalResourceServiceResNodeProxy;
import com.fizzgate.config.AggregateRedisConfig;
import com.fizzgate.config.SystemConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.listener.ReactiveRedisMessageListenerContainer;

import static com.fizzgate.config.AggregateRedisConfig.AGGREGATE_REACTIVE_REDIS_MESSAGE_LISTENER_CONTAINER;

@Configuration
public class FizzAggregateAutoConfiguration {

    @Bean
    public ConfigLoaderProperties configLoaderProperties() {
        return new ConfigLoaderProperties();
    }

    @Bean
    public AppConfigProperties appConfigProperties() {
        return new AppConfigProperties();
    }

    @Bean
    public ConfigLoader configLoader(ConfigurableApplicationContext applicationContext,
                                     @Qualifier(AggregateRedisConfig.AGGREGATE_REACTIVE_REDIS_TEMPLATE)
                                     ReactiveStringRedisTemplate reactiveStringRedisTemplate,
                                     ConfigLoaderProperties configLoaderProperties,
                                     AppConfigProperties appConfigProperties) throws Exception {

        NodeFactory.registerBuilder(RequestNode.TYPE, new RequestNode.RequestNodeBuilder());
        NodeFactory.registerBuilder(GrpcNode.TYPE, new GrpcNode.GrpcNodeBuilder());
        NodeFactory.registerBuilder(DubboNode.TYPE, new DubboNode.DubboNodeBuilder());

        ApplicationContextUtils.APPLICATION_CONTEXT = applicationContext;
        GlobalResourceUtils.resNode = GlobalResourceServiceResNodeProxy.INSTANCE;

        ConfigLoader configLoader = new ConfigLoader(applicationContext, reactiveStringRedisTemplate,
                configLoaderProperties, appConfigProperties);
        configLoader.init();
        return configLoader;
    }

    @Bean
    public AggregateFilterProperties aggregateFilterProperties() {
        return new AggregateFilterProperties();
    }

    @Bean
    public AggregateFilter aggregateFilter(ConfigLoader configLoader,
                                           AggregateFilterProperties aggregateFilterProperties,
                                           SystemConfig systemConfig) {
        return new AggregateFilter(configLoader, aggregateFilterProperties, systemConfig);
    }

    @Bean
    public AggregateChannelListener aggregateChannelListener(
            @Qualifier(AGGREGATE_REACTIVE_REDIS_MESSAGE_LISTENER_CONTAINER)
            ReactiveRedisMessageListenerContainer reactiveRedisMessageListenerContainer,
            ConfigLoader configLoader) {
        return new AggregateChannelListener(reactiveRedisMessageListenerContainer, configLoader);
    }
}
