/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.web.flow.extension.grpc;

import com.alibaba.fastjson.JSON;
import com.fizzgate.aggregate.core.exception.ExecuteScriptException;
import com.fizzgate.aggregate.core.exception.FizzRuntimeException;
import com.fizzgate.aggregate.core.flow.FlowContext;
import com.fizzgate.aggregate.core.flow.INode;
import com.fizzgate.aggregate.core.flow.INodeBuilder;
import com.fizzgate.aggregate.core.flow.PathMapping;
import com.fizzgate.aggregate.core.script.ScriptExecutor;
import com.fizzgate.aggregate.core.util.JacksonUtils;
import com.fizzgate.aggregate.core.util.LogUtils;
import com.fizzgate.aggregate.web.flow.RPCNode;
import com.fizzgate.aggregate.web.flow.RPCResponse;
import com.fizzgate.aggregate.web.flow.extension.grpc.GrpcNodeConfig;
import com.fizzgate.aggregate.web.flow.extension.grpc.GrpcRPCResponse;
import com.fizzgate.aggregate.web.util.ApplicationContextUtils;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.proxy.grpc.GrpcGenericService;
import com.fizzgate.proxy.grpc.GrpcInstanceService;
import com.fizzgate.proxy.grpc.GrpcInterfaceDeclaration;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class GrpcNode
extends RPCNode<GrpcNodeConfig> {
    private static final Logger String = LoggerFactory.getLogger(GrpcNode.class);
    public static final String TYPE = "GRPC";

    public GrpcNode(GrpcNodeConfig grpcNodeConfig, FlowContext flowContext) {
        super(grpcNodeConfig, flowContext);
    }

    @Override
    protected Mono<RPCResponse> getClientSpecFromContext() {
        int n = ((GrpcNodeConfig)this.config).getTimeout() < 1 ? 10000 : Math.min(((GrpcNodeConfig)this.config).getTimeout(), 30000);
        long l = ((GrpcNodeConfig)this.config).getNumRetries() > 0L ? ((GrpcNodeConfig)this.config).getNumRetries() : 0L;
        long l2 = ((GrpcNodeConfig)this.config).getRetryInterval() > 0L ? ((GrpcNodeConfig)this.config).getRetryInterval() : 0L;
        Map map = (Map)this.context.getNode(super.getName()).get("request");
        Map map2 = (Map)map.get("attachments");
        Map map3 = (Map)map.get("body");
        String string2 = (String)map.get("endpoint");
        GrpcGenericService grpcGenericService = ApplicationContextUtils.getBean(GrpcGenericService.class);
        GrpcInterfaceDeclaration grpcInterfaceDeclaration = new GrpcInterfaceDeclaration();
        grpcInterfaceDeclaration.setEndpoint(string2);
        grpcInterfaceDeclaration.setServiceName(((GrpcNodeConfig)this.config).getServiceName());
        grpcInterfaceDeclaration.setMethod(((GrpcNodeConfig)this.config).getMethod());
        grpcInterfaceDeclaration.setTimeout(n);
        HashMap<String, String> hashMap = map2 == null ? new HashMap<String, String>() : new HashMap(map2);
        SystemConfig systemConfig = ApplicationContextUtils.getBean(SystemConfig.class);
        if (this.context.getTraceId() != null) {
            hashMap.put(systemConfig.fizzTraceIdHeader(), this.context.getTraceId());
        }
        HashMap<String, String> hashMap2 = hashMap;
        Mono mono = Mono.just((Object)"").flatMap(string -> grpcGenericService.send(JSON.toJSONString((Object)map3), grpcInterfaceDeclaration, hashMap2));
        return mono.retryWhen((Retry)Retry.fixedDelay((long)l, (Duration)Duration.ofMillis(l2)).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            throw new FizzRuntimeException("External gRPC Service failed to process after max retries");
        })).flatMap(object -> {
            GrpcRPCResponse grpcRPCResponse = new GrpcRPCResponse();
            grpcRPCResponse.setBodyMono((Mono<Object>)Mono.just((Object)object));
            return Mono.just((Object)grpcRPCResponse);
        });
    }

    @Override
    protected void doRequestMapping() {
        Map map;
        Map map2 = (Map)this.context.getNode(super.getName()).get("request");
        map2.put("serviceName", ((GrpcNodeConfig)this.config).getServiceName());
        map2.put("method", ((GrpcNodeConfig)this.config).getMethod());
        GrpcInstanceService grpcInstanceService = ApplicationContextUtils.getBean(GrpcInstanceService.class);
        map2.put("endpoint", grpcInstanceService.getInstance(((GrpcNodeConfig)this.config).getServiceName()));
        Map<String, Object> map3 = ((GrpcNodeConfig)this.config).getDataMapping();
        if (map3 != null && !CollectionUtils.isEmpty((Map)(map = (Map)map3.get("request")))) {
            ONode oNode = this.context.toONode();
            Map map4 = PathMapping.transform((ONode)oNode, (FlowContext)this.context, (Map)((Map)map.get("fixedHeaders")), (Map)((Map)map.get("headers")));
            if (map4.containsKey("~") && map4.get("~") instanceof Map) {
                map2.put("attachments", map4.get("~"));
            } else {
                map2.put("attachments", map4);
            }
            Map map5 = PathMapping.transform((ONode)oNode, (FlowContext)this.context, (Map)((Map)map.get("fixedBody")), (Map)((Map)map.get("body")));
            if (map5.containsKey("~")) {
                map2.put("body", map5.get("~"));
            } else {
                if (map.get("script") != null) {
                    Map map6 = (Map)map.get("script");
                    try {
                        Object object = ScriptExecutor.execute((Map)map6, (ONode)oNode, (FlowContext)this.context);
                        if (object != null) {
                            map5.putAll((Map)object);
                        }
                    }
                    catch (ScriptException scriptException) {
                        LogUtils.warn((Logger)String, (String)this.context.getTraceId(), (String)"execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)map6), (Object)scriptException);
                        throw new ExecuteScriptException((Throwable)scriptException, this.context, (Object)map6);
                    }
                }
                map2.put("body", map5);
            }
        }
    }

    @Override
    protected void doOnResponseSuccess(RPCResponse rPCResponse, long l) {
        this.context.addElapsedTime(this.\u00d300000(), Long.valueOf(l));
    }

    @Override
    protected Mono<Object> bodyToMono(RPCResponse rPCResponse) {
        return rPCResponse.getBodyMono();
    }

    @Override
    protected void doOnBodyError(Throwable throwable, long l) {
        LogUtils.warn((Logger)String, (String)this.context.getTraceId(), (String)"failed to call {}", (Object)this.\u00d300000(), (Object)throwable);
        this.context.addElapsedTime(this.\u00d300000() + " failed ", Long.valueOf(l));
    }

    @Override
    protected void doOnBodySuccess(Object object, long l) {
    }

    @Override
    protected void doResponseMapping(Object object) {
        Map map = (Map)this.context.getNode(super.getName()).get("response");
        map.put("body", object);
        Map<String, Object> map2 = ((GrpcNodeConfig)this.config).getDataMapping();
        if (map2 != null) {
            Map map3 = (Map)map2.get("response");
            if (!CollectionUtils.isEmpty((Map)map3)) {
                ONode oNode = this.context.toONode();
                Map map4 = (Map)map3.get("fixedBody");
                Map map5 = (Map)map3.get("body");
                Map map6 = (Map)map3.get("script");
                if (map4 != null && !map4.isEmpty() || map5 != null && !map5.isEmpty() || map6 != null && map6.get("type") != null && map6.get("source") != null) {
                    HashMap hashMap = new HashMap(PathMapping.transform((ONode)oNode, (FlowContext)this.context, (Map)map4, (Map)map5));
                    if (hashMap.containsKey("~")) {
                        map.put("body", hashMap.get("~"));
                    } else {
                        if (map6 != null && map6.get("type") != null && map6.get("source") != null) {
                            try {
                                Object object2 = ScriptExecutor.execute((Map)map6, (ONode)oNode, (FlowContext)this.context);
                                if (object2 != null) {
                                    hashMap.putAll((Map)object2);
                                }
                            }
                            catch (ScriptException scriptException) {
                                LogUtils.warn((Logger)String, (String)this.context.getTraceId(), (String)"execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)map6), (Object)scriptException);
                                throw new ExecuteScriptException((Throwable)scriptException, this.context, (Object)map6);
                            }
                        }
                        map.put("body", hashMap);
                    }
                }
            }
        } else {
            map.put("body", object);
        }
    }

    private String \u00d300000() {
        Map map = (Map)this.context.getNode(super.getName()).get("request");
        return this.prefix + " - " + map.get("serviceName") + " - " + map.get("method");
    }

    public static class GrpcNodeBuilder
    implements INodeBuilder {
        public INode build(Map<String, Object> map, FlowContext flowContext) {
            return new GrpcNode(new GrpcNodeConfig(map), flowContext);
        }
    }
}

