/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.web.util;

import com.fizzgate.aggregate.core.exception.ExecuteScriptException;
import com.fizzgate.aggregate.core.exception.FizzRuntimeException;
import com.fizzgate.aggregate.core.exception.RedirectException;
import com.fizzgate.aggregate.core.exception.StopAndResponseException;
import com.fizzgate.aggregate.web.legacy.exception.B;
import com.fizzgate.aggregate.web.legacy.exception.super;
import com.fizzgate.legacy.RespEntity;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.WebUtils;
import java.net.URI;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class AggregateExceptionHandleUtils {
    private static final String o00000 = "AggregateExceptionHandler";

    public static boolean needHandle(Throwable throwable) {
        return throwable instanceof StopAndResponseException || throwable instanceof RedirectException || throwable instanceof ExecuteScriptException || throwable instanceof B || throwable instanceof FizzRuntimeException || throwable instanceof super;
    }

    public static Mono<Void> handle(ServerWebExchange serverWebExchange, HttpHeaders httpHeaders, ServerHttpResponse serverHttpResponse, Throwable throwable, String string, Logger logger) {
        Mono mono;
        Object object;
        if (throwable instanceof StopAndResponseException && (object = (StopAndResponseException)throwable).getData() != null) {
            httpHeaders.add("Content-Type", "application/json");
            return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(object.getData().getBytes())));
        }
        if (throwable instanceof RedirectException && (object = (RedirectException)throwable).getRedirectUrl() != null) {
            serverHttpResponse.setStatusCode(HttpStatus.MOVED_PERMANENTLY);
            httpHeaders.setLocation(URI.create(object.getRedirectUrl()));
            return Mono.empty();
        }
        object = throwable.getMessage();
        if (object == null) {
            object = throwable.toString();
        }
        if (throwable instanceof ExecuteScriptException) {
            ExecuteScriptException executeScriptException = (ExecuteScriptException)throwable;
            httpHeaders.add("Content-Type", "application/json");
            if (executeScriptException.getFlowContext() != null && executeScriptException.getFlowContext().returnContext()) {
                RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string, (Object)executeScriptException.getFlowContext());
                return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(JacksonUtils.writeValueAsBytes((Object)respEntity))));
            }
            RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string);
            return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(respEntity.toString().getBytes())));
        }
        if (throwable instanceof FizzRuntimeException) {
            FizzRuntimeException fizzRuntimeException = (FizzRuntimeException)throwable;
            ThreadContext.put((String)"traceId", (String)string);
            logger.error((String)object, (Throwable)fizzRuntimeException);
            httpHeaders.add("Content-Type", "application/json");
            if (fizzRuntimeException.getFlowContext() != null && fizzRuntimeException.getFlowContext().returnContext()) {
                RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string, (Object)fizzRuntimeException.getFlowContext());
                return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(JacksonUtils.writeValueAsString((Object)respEntity).getBytes())));
            }
            RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string);
            return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(respEntity.toString().getBytes())));
        }
        if (throwable instanceof B) {
            B b = (B)throwable;
            httpHeaders.add("Content-Type", "application/json");
            if (b.o00000() != null && b.o00000().\u00d300000()) {
                RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string, b.o00000());
                return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(JacksonUtils.writeValueAsBytes((Object)respEntity))));
            }
            RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string);
            return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(respEntity.toString().getBytes())));
        }
        if (throwable instanceof super) {
            super super_ = (super)throwable;
            ThreadContext.put((String)"traceId", (String)string);
            logger.error((String)object, (Throwable)super_);
            httpHeaders.add("Content-Type", "application/json");
            if (super_.o00000() != null && super_.o00000().\u00d300000()) {
                RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string, super_.o00000());
                return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(JacksonUtils.writeValueAsString((Object)respEntity).getBytes())));
            }
            RespEntity respEntity = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, string);
            return serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(respEntity.toString().getBytes())));
        }
        Object object2 = serverWebExchange.getAttribute("fc@");
        if (object2 == null) {
            StringBuilder stringBuilder = com.fizzgate.util.ThreadContext.getStringBuilder();
            WebUtils.request2stringBuilder((ServerWebExchange)serverWebExchange, (StringBuilder)stringBuilder);
            ThreadContext.put((String)"traceId", (String)string);
            logger.error(stringBuilder.toString(), throwable);
            String string2 = WebUtils.jsonRespBody((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, (String)string);
            httpHeaders.add("Content-Type", "application/json");
            mono = serverHttpResponse.writeWith((Publisher)Mono.just((Object)serverHttpResponse.bufferFactory().wrap(string2.getBytes())));
        } else {
            mono = WebUtils.responseError((ServerWebExchange)serverWebExchange, (String)o00000, (int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)object, (Throwable)throwable);
        }
        return mono;
    }

    private AggregateExceptionHandleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

