/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.web.util;

import com.fizzgate.aggregate.web.util.UUIDUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class MapUtil {
    private static final String o00000 = "key";
    private static final String \u00d200000 = "value";

    public static HttpHeaders toHttpHeaders(Map<String, Object> map) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (map == null || map.isEmpty()) {
            return httpHeaders;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object instanceof List) {
                List list = (List)object;
                for (Object e : list) {
                    if (e == null) continue;
                    arrayList.add(e.toString());
                }
            } else if (object != null) {
                arrayList.add(object.toString());
            }
            if (arrayList.size() <= 0) continue;
            httpHeaders.put(entry.getKey(), arrayList);
        }
        return httpHeaders;
    }

    public static MultiValueMap<String, String> toMultiValueMap(Map<String, Object> map) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        if (map == null || map.isEmpty()) {
            return linkedMultiValueMap;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object instanceof List) {
                List list = (List)object;
                for (Object e : list) {
                    if (e == null) continue;
                    arrayList.add(e.toString());
                }
            } else if (object != null) {
                arrayList.add(object.toString());
            }
            if (arrayList.size() <= 0) continue;
            linkedMultiValueMap.put((Object)entry.getKey(), arrayList);
        }
        return linkedMultiValueMap;
    }

    public static MultiValueMap<String, Object> toMultipartDataMap(Map<String, Object> map) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        if (map == null || map.isEmpty()) {
            return linkedMultiValueMap;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            ArrayList arrayList = new ArrayList();
            if (object instanceof List) {
                List list = (List)object;
                for (Object e : list) {
                    if (e == null) continue;
                    arrayList.add(e);
                }
            } else if (object != null) {
                arrayList.add(object.toString());
            }
            if (arrayList.size() <= 0) continue;
            linkedMultiValueMap.put((Object)entry.getKey(), arrayList);
        }
        return linkedMultiValueMap;
    }

    public static Map<String, Object> extractFormData(MultiValueMap<String, Part> multiValueMap, String string, Map<String, FilePart> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (multiValueMap == null || multiValueMap.isEmpty()) {
            return hashMap;
        }
        for (Map.Entry entry : multiValueMap.entrySet()) {
            FormFieldPart formFieldPart;
            List list = (List)entry.getValue();
            if (list == null || list.size() <= 0) continue;
            if (list.size() > 1) {
                formFieldPart = new ArrayList();
                list.stream().forEach(part -> {
                    if (part instanceof FormFieldPart) {
                        FormFieldPart formFieldPart = (FormFieldPart)part;
                        formFieldPart.add(formFieldPart.value());
                    } else if (part instanceof FilePart) {
                        FilePart filePart = (FilePart)part;
                        String string2 = string + UUIDUtil.getUUID() + "-" + filePart.filename();
                        formFieldPart.add(string2);
                        map.put(string2, filePart);
                    }
                });
                if (formFieldPart.size() <= 0) continue;
                hashMap.put((String)entry.getKey(), formFieldPart);
                continue;
            }
            if (list.get(0) instanceof FormFieldPart) {
                formFieldPart = (FormFieldPart)list.get(0);
                hashMap.put((String)entry.getKey(), formFieldPart.value());
                continue;
            }
            if (!(list.get(0) instanceof FilePart)) continue;
            formFieldPart = (FilePart)list.get(0);
            String string2 = string + UUIDUtil.getUUID() + "-" + formFieldPart.filename();
            hashMap.put((String)entry.getKey(), string2);
            map.put(string2, (FilePart)formFieldPart);
        }
        return hashMap;
    }

    public static void replaceWithFilePart(MultiValueMap<String, Object> multiValueMap, String string, Map<String, FilePart> map) {
        if (multiValueMap == null || multiValueMap.isEmpty() || map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : multiValueMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.size() <= 0) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).toString().startsWith(string)) {
                    arrayList.add(map.get(list.get(i).toString()));
                    continue;
                }
                arrayList.add(list.get(i));
            }
            multiValueMap.put(entry.getKey(), arrayList);
        }
    }

    public static Map<String, Object> toHashMap(MultiValueMap<String, String> multiValueMap) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (multiValueMap == null || multiValueMap.isEmpty()) {
            return hashMap;
        }
        for (Map.Entry entry : multiValueMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.size() <= 0) continue;
            if (list.size() > 1) {
                hashMap.put((String)entry.getKey(), list);
                continue;
            }
            hashMap.put((String)entry.getKey(), list.get(0));
        }
        return hashMap;
    }

    public static Map<String, Object> headerToHashMap(HttpHeaders httpHeaders) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return hashMap;
        }
        for (Map.Entry entry : httpHeaders.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.size() <= 0) continue;
            if (list.size() > 1) {
                hashMap.put(((String)entry.getKey()).toUpperCase(), list);
                continue;
            }
            hashMap.put(((String)entry.getKey()).toUpperCase(), list.get(0));
        }
        return hashMap;
    }

    public static Map<String, Object> upperCaseKey(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map == null || map.isEmpty()) {
            return hashMap;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return hashMap;
    }

    public static MultiValueMap<String, Object> upperCaseKey(MultiValueMap<String, Object> multiValueMap) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        if (multiValueMap == null || multiValueMap.isEmpty()) {
            return linkedMultiValueMap;
        }
        for (Map.Entry entry : multiValueMap.entrySet()) {
            linkedMultiValueMap.put((Object)((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return linkedMultiValueMap;
    }

    public static void set(Map<String, Object> map, String string, Object object) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            map.put(string, object);
        } else {
            Map<String, Object> map2 = map;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                HashMap<String, Object> hashMap = (HashMap<String, Object>)map2.get(stringArray[i]);
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                    map2.put(stringArray[i], hashMap);
                }
                if (i == stringArray.length - 2) {
                    hashMap.put(stringArray[i + 1], object);
                    break;
                }
                map2 = hashMap;
            }
        }
    }

    public static Object get(Map<String, Object> map, String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return map.get(string);
        }
        Map map2 = map;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!(map2.get(stringArray[i]) instanceof Map)) {
                return null;
            }
            Map map3 = (Map)map2.get(stringArray[i]);
            if (map3 == null) {
                return null;
            }
            if (i == stringArray.length - 2) {
                return map3.get(stringArray[i + 1]);
            }
            map2 = map3;
        }
        return null;
    }

    public static Map<String, Object> merge(Map<String, Object> map, Map<String, Object> map2) {
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        map2.forEach((string, object2) -> {
            if (object2 != null) {
                map.merge((String)string, object2, (map, object) -> {
                    if (map instanceof Map && object instanceof Map) {
                        map = MapUtil.merge(map, (Map)object);
                        return map;
                    }
                    return object;
                });
            } else {
                map.put((String)string, object2);
            }
        });
        return map;
    }

    public static Map<String, Object> list2Map(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof List) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List list = (List)object;
            if (list == null || list.size() == 0) {
                return hashMap;
            }
            for (Map map : list) {
                String string = map.get(o00000).toString();
                Object v = map.get(\u00d200000);
                if (hashMap.containsKey(string)) {
                    List list2 = null;
                    if (hashMap.get(string) instanceof List) {
                        list2 = (List)hashMap.get(string);
                    } else {
                        list2 = new ArrayList();
                        list2.add(hashMap.get(string));
                    }
                    list2.add(v);
                    hashMap.put(string, list2);
                    continue;
                }
                hashMap.put(string, v);
            }
            return hashMap;
        }
        return null;
    }

    public static MultiValueMap<String, Object> listToMultiValueMap(List<Map<String, Object>> list) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        if (list == null || list.size() == 0) {
            return linkedMultiValueMap;
        }
        for (Map<String, Object> map : list) {
            linkedMultiValueMap.add((Object)map.get(o00000).toString(), map.get(\u00d200000));
        }
        return linkedMultiValueMap;
    }

    private MapUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

