/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.RedisReactiveProperties;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

public abstract class RedisReactiveConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RedisReactiveConfig.class);
    private static final int ps = Runtime.getRuntime().availableProcessors();
    @Deprecated
    public static final ClientResources clientResources;
    public static final ClientResources CLIENT_RESOURCES;
    private RedisReactiveProperties redisReactiveProperties;

    public RedisReactiveConfig(RedisReactiveProperties properties) {
        this.redisReactiveProperties = properties;
    }

    public ReactiveStringRedisTemplate reactiveStringRedisTemplate(ReactiveRedisConnectionFactory fact) {
        return new ReactiveStringRedisTemplate(fact);
    }

    public ReactiveRedisConnectionFactory lettuceConnectionFactory() {
        LettuceConnectionFactory reactiveRedisConnectionFactory;
        if (this.redisReactiveProperties.getType() == "standalone") {
            RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(this.redisReactiveProperties.getHost(), this.redisReactiveProperties.getPort());
            String password = this.redisReactiveProperties.getPassword();
            if (password != null) {
                redisStandaloneConfiguration.setPassword(password);
            }
            redisStandaloneConfiguration.setDatabase(this.redisReactiveProperties.getDatabase());
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(poolConfig.getMaxTotal() * 2);
            LettucePoolingClientConfiguration clientConfiguration = LettucePoolingClientConfiguration.builder().clientResources(clientResources).clientOptions(ClientOptions.builder().publishOnScheduler(true).build()).poolConfig(poolConfig).build();
            reactiveRedisConnectionFactory = new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfiguration);
        } else {
            Duration timeBetweenEvictionRuns;
            int maxTotal;
            int maxIdle;
            RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
            String password = this.redisReactiveProperties.getPassword();
            if (password != null) {
                redisClusterConfiguration.setPassword(password);
            }
            redisClusterConfiguration.setClusterNodes(this.redisReactiveProperties.getClusterNodes());
            int maxRedirects = this.redisReactiveProperties.getMaxRedirects();
            if (maxRedirects > 0) {
                redisClusterConfiguration.setMaxRedirects(maxRedirects);
            }
            ClusterTopologyRefreshOptions.Builder builder = ClusterTopologyRefreshOptions.builder();
            int clusterRefreshPeriod = this.redisReactiveProperties.getClusterRefreshPeriod();
            builder = builder.enablePeriodicRefresh(Duration.ofSeconds(clusterRefreshPeriod));
            boolean enableAllAdaptiveRefreshTriggers = this.redisReactiveProperties.isEnableAllAdaptiveRefreshTriggers();
            if (enableAllAdaptiveRefreshTriggers) {
                builder = builder.enableAllAdaptiveRefreshTriggers();
            }
            ClusterTopologyRefreshOptions topologyRefreshOptions = builder.build();
            ClusterClientOptions clusterClientOptions = ClusterClientOptions.builder().timeoutOptions(TimeoutOptions.enabled((Duration)Duration.ofSeconds(clusterRefreshPeriod))).topologyRefreshOptions(topologyRefreshOptions).publishOnScheduler(true).build();
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            int minIdle = this.redisReactiveProperties.getMinIdle();
            if (minIdle > 0) {
                poolConfig.setMinIdle(minIdle);
            }
            if ((maxIdle = this.redisReactiveProperties.getMaxIdle()) > 0) {
                poolConfig.setMaxIdle(maxIdle);
            }
            if ((maxTotal = this.redisReactiveProperties.getMaxTotal()) > 0) {
                poolConfig.setMaxTotal(maxTotal);
            } else {
                poolConfig.setMaxTotal(poolConfig.getMaxTotal() * 2);
            }
            Duration maxWait = this.redisReactiveProperties.getMaxWait();
            if (maxWait != null) {
                poolConfig.setMaxWait(maxWait);
            }
            if ((timeBetweenEvictionRuns = this.redisReactiveProperties.getTimeBetweenEvictionRuns()) != null) {
                poolConfig.setTimeBetweenEvictionRuns(timeBetweenEvictionRuns);
            }
            LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().clientResources(clientResources).poolConfig(poolConfig).readFrom(this.redisReactiveProperties.getReadFrom()).clientOptions((ClientOptions)clusterClientOptions).build();
            reactiveRedisConnectionFactory = new LettuceConnectionFactory(redisClusterConfiguration, (LettuceClientConfiguration)clientConfig);
        }
        LOGGER.info("build reactive redis connection factory for {}", (Object)this.redisReactiveProperties);
        return reactiveRedisConnectionFactory;
    }

    static {
        CLIENT_RESOURCES = clientResources = DefaultClientResources.builder().ioThreadPoolSize(ps).computationThreadPoolSize(ps).build();
    }
}

