/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.util.StringUtils;
import com.fizzgate.util.Utils;
import io.lettuce.core.ReadFrom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.RedisNode;

public abstract class RedisReactiveProperties {
    public static final String STANDALONE = "standalone";
    public static final String CLUSTER = "cluster";
    private String type = "standalone";
    private String host = "127.0.0.1";
    private int port = 6379;
    private String password;
    private int database = 0;
    private List<RedisNode> clusterNodes;
    private int maxRedirects = 0;
    private int clusterRefreshPeriod = 60;
    private boolean clusterRefreshAdaptive = true;
    private boolean enableAllAdaptiveRefreshTriggers = true;
    private ReadFrom readFrom = ReadFrom.REPLICA_PREFERRED;
    private int minIdle = 0;
    private int maxIdle = 0;
    private int maxTotal = 0;
    private Duration maxWait;
    private Duration timeBetweenEvictionRuns;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type.equals(STANDALONE) ? STANDALONE : CLUSTER;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public List<RedisNode> getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(String clusterNodes) {
        String[] nodeArr = StringUtils.split((String)clusterNodes, (char)',');
        this.clusterNodes = new ArrayList<RedisNode>(nodeArr.length);
        for (String n : nodeArr) {
            String[] ipAndPort = StringUtils.split((String)n.trim(), (char)':');
            RedisNode redisNode = new RedisNode(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
            this.clusterNodes.add(redisNode);
        }
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public int getClusterRefreshPeriod() {
        return this.clusterRefreshPeriod;
    }

    public void setClusterRefreshPeriod(int clusterRefreshPeriod) {
        this.clusterRefreshPeriod = clusterRefreshPeriod;
    }

    public boolean isClusterRefreshAdaptive() {
        return this.clusterRefreshAdaptive;
    }

    public void setClusterRefreshAdaptive(boolean clusterRefreshAdaptive) {
        this.clusterRefreshAdaptive = clusterRefreshAdaptive;
    }

    public boolean isEnableAllAdaptiveRefreshTriggers() {
        return this.enableAllAdaptiveRefreshTriggers;
    }

    public void setEnableAllAdaptiveRefreshTriggers(boolean enableAllAdaptiveRefreshTriggers) {
        this.enableAllAdaptiveRefreshTriggers = enableAllAdaptiveRefreshTriggers;
    }

    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(String readFrom) {
        this.readFrom = ReadFrom.valueOf((String)readFrom);
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public Duration getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = Duration.ofMillis(maxWait);
    }

    public Duration getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public void setTimeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = Duration.ofMillis(timeBetweenEvictionRuns);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(256);
        this.appendTo(b);
        return b.toString();
    }

    public void appendTo(StringBuilder b) {
        b.append('{');
        if (this.type == STANDALONE) {
            Utils.addTo(b, "host", '=', this.host, " ");
            Utils.addTo(b, "port", '=', this.port, " ");
            Utils.addTo(b, "database", '=', this.database, " ");
        } else {
            Utils.addTo(b, "clusterNodes", '=', this.clusterNodes, " ");
            Utils.addTo(b, "maxRedirects", '=', this.maxRedirects, " ");
            Utils.addTo(b, "clusterRefreshPeriod", '=', this.clusterRefreshPeriod, " ");
            Utils.addTo(b, "clusterRefreshAdaptive", '=', this.clusterRefreshAdaptive, " ");
            Utils.addTo(b, "enableAllAdaptiveRefreshTriggers", '=', this.enableAllAdaptiveRefreshTriggers, " ");
            Utils.addTo(b, "readFrom", '=', this.readFrom, " ");
        }
        Utils.addTo(b, "minIdle", '=', this.minIdle, " ");
        Utils.addTo(b, "maxIdle", '=', this.maxIdle, " ");
        Utils.addTo(b, "maxWait", '=', this.maxWait, " ");
        Utils.addTo(b, "maxTotal", '=', this.maxTotal, " ");
        Utils.addTo(b, "timeBetweenEvictionRuns", '=', this.timeBetweenEvictionRuns, "");
        b.append('}');
    }
}

