/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.codec.CodecsAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorAutoConfiguration;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@AutoConfigureAfter(value={CodecsAutoConfiguration.class, ClientHttpConnectorAutoConfiguration.class})
public class WebClientBuilderConfig {
    private final WebClient.Builder webClientBuilder = WebClient.builder();

    public WebClientBuilderConfig(ObjectProvider<WebClientCustomizer> customizerProvider) {
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(this.webClientBuilder));
    }

    public WebClient.Builder getBuilder() {
        return this.webClientBuilder.clone();
    }
}

