/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.WebClientBuilderConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

public abstract class WebClientConfig {
    protected static final Logger log = LoggerFactory.getLogger(WebClientConfig.class);
    private Long connReadTimeout = null;
    private Long connWriteTimeout = null;
    private Integer chConnTimeout = null;
    private Boolean chTcpNodelay = null;
    private Boolean chSoKeepAlive = null;
    private Boolean compress = null;
    private Boolean trustInsecureSSL = null;
    @Resource
    WebClientBuilderConfig webClientBuilderConfig;

    public Boolean getTrustInsecureSSL() {
        return this.trustInsecureSSL;
    }

    public void setTrustInsecureSSL(Boolean trustInsecureSSL) {
        this.trustInsecureSSL = trustInsecureSSL;
    }

    public Long getConnReadTimeout() {
        return this.connReadTimeout;
    }

    public void setConnReadTimeout(Long connReadTimeout) {
        this.connReadTimeout = connReadTimeout;
    }

    public Long getConnWriteTimeout() {
        return this.connWriteTimeout;
    }

    public void setConnWriteTimeout(Long connWriteTimeout) {
        this.connWriteTimeout = connWriteTimeout;
    }

    public Integer getChConnTimeout() {
        return this.chConnTimeout;
    }

    public void setChConnTimeout(Integer chConnTimeout) {
        this.chConnTimeout = chConnTimeout;
    }

    public Boolean isChTcpNodelay() {
        return this.chTcpNodelay;
    }

    public void setChTcpNodelay(Boolean chTcpNodelay) {
        this.chTcpNodelay = chTcpNodelay;
    }

    public Boolean isChSoKeepAlive() {
        return this.chSoKeepAlive;
    }

    public void setChSoKeepAlive(Boolean chSoKeepAlive) {
        this.chSoKeepAlive = chSoKeepAlive;
    }

    public Boolean isCompress() {
        return this.compress;
    }

    public void setCompress(Boolean compress) {
        this.compress = compress;
    }

    public WebClient webClient() {
        HttpClient httpClient = HttpClient.create().tcpConfiguration(tcpClient -> {
            TcpClient newTcpClient = tcpClient.doOnConnected(connection -> {
                if (this.connReadTimeout != null) {
                    connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(this.connReadTimeout.longValue(), TimeUnit.MILLISECONDS));
                }
                if (this.connWriteTimeout != null) {
                    connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler(this.connWriteTimeout.longValue(), TimeUnit.MILLISECONDS));
                }
            });
            if (this.chConnTimeout != null) {
                newTcpClient = newTcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.chConnTimeout);
            }
            if (this.chTcpNodelay != null) {
                newTcpClient = newTcpClient.option(ChannelOption.TCP_NODELAY, (Object)this.chTcpNodelay);
            }
            if (this.chSoKeepAlive != null) {
                newTcpClient = newTcpClient.option(ChannelOption.SO_KEEPALIVE, (Object)this.chSoKeepAlive);
            }
            return newTcpClient;
        });
        if (this.compress != null) {
            httpClient = httpClient.compress(this.compress.booleanValue());
        }
        if (this.trustInsecureSSL != null && this.trustInsecureSSL.booleanValue()) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                httpClient = httpClient.secure(spec -> spec.sslContext(sslContext));
                log.warn("disable SSL verification");
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.webClientBuilderConfig.getBuilder().exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(-1)).build()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public String toString() {
        return "{ connReadTimeout=" + this.connReadTimeout + ", connWriteTimeout=" + this.connWriteTimeout + ", chConnTimeout=" + this.chConnTimeout + ", chTcpNodelay=" + this.chTcpNodelay + ", chSoKeepAlive=" + this.chSoKeepAlive + ", compress=" + this.compress + ", trustInsecureSSL=" + this.trustInsecureSSL + " }";
    }
}

