/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.ErrorMessageType;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJsonValidator
implements JsonValidator {
    private final String keyword;

    protected AbstractJsonValidator(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at, String ... arguments) {
        return ValidationMessage.of(this.keyword, errorMessageType, at, arguments);
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at, Map<String, Object> details) {
        return ValidationMessage.of(this.keyword, errorMessageType, at, details);
    }

    protected Set<ValidationMessage> pass() {
        return Collections.emptySet();
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at, Map<String, Object> details) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at, details));
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at, String ... arguments) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at, arguments));
    }
}

