/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaxPropertiesValidator.class);
    private int max;

    public MaxPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_PROPERTIES, validationContext);
        if (schemaNode.isIntegralNumber()) {
            this.max = schemaNode.intValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (node.isObject() && node.size() > this.max) {
            String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
            return Collections.singleton(this.buildValidationMessage(at, "" + this.max, title));
        }
        return Collections.emptySet();
    }
}

